/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.solver.smart.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchSwapMove
implements Move,
TabuPropertyEnabled {
    private Match firstMatch;
    private Match secondMatch;

    public MatchSwapMove(Match firstMatch, Match secondMatch) {
        this.firstMatch = firstMatch;
        this.secondMatch = secondMatch;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return true;
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return this;
    }

    public void doMove(WorkingMemory workingMemory) {
        Day oldFirstMatchDay = this.firstMatch.getDay();
        FactHandle firstMatchHandle = workingMemory.getFactHandle((Object)this.firstMatch);
        FactHandle secondMatchHandle = workingMemory.getFactHandle((Object)this.secondMatch);
        workingMemory.modifyRetract(firstMatchHandle);
        workingMemory.modifyRetract(secondMatchHandle);
        this.firstMatch.setDay(this.secondMatch.getDay());
        this.secondMatch.setDay(oldFirstMatchDay);
        workingMemory.modifyInsert(firstMatchHandle, (Object)this.firstMatch);
        workingMemory.modifyInsert(secondMatchHandle, (Object)this.secondMatch);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.firstMatch, this.secondMatch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchSwapMove) {
            MatchSwapMove other = (MatchSwapMove)o;
            return new EqualsBuilder().append((Object)this.firstMatch, (Object)other.firstMatch).append((Object)this.secondMatch, (Object)other.secondMatch).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.firstMatch).append((Object)this.secondMatch).toHashCode();
    }

    public String toString() {
        return this.firstMatch + " <=> " + this.secondMatch;
    }
}

