/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;
import org.drools.solver.examples.travelingtournament.domain.TravelingTournament;
import org.drools.solver.examples.travelingtournament.solver.simple.move.DayChangeMove;

public class TravelingTournamentPanel
extends SolutionPanel {
    public TravelingTournamentPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    private TravelingTournament getTravelingTournament() {
        return (TravelingTournament)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        DayPanel dayPanel;
        this.removeAll();
        TravelingTournament travelingTournament = this.getTravelingTournament();
        HashMap<Day, DayPanel> dayPanelMap = new HashMap<Day, DayPanel>();
        for (Day day : travelingTournament.getDayList()) {
            dayPanel = new DayPanel();
            this.add(dayPanel);
            dayPanelMap.put(day, dayPanel);
        }
        for (Match match : travelingTournament.getMatchList()) {
            dayPanel = (DayPanel)dayPanelMap.get(match.getDay());
            dayPanel.addMatch(match);
        }
    }

    private class MatchAction
    extends AbstractAction {
        private Match match;

        public MatchAction(Match match) {
            super(match.toString());
            this.match = match;
        }

        public void actionPerformed(ActionEvent e) {
            List<Day> dayList = TravelingTournamentPanel.this.getTravelingTournament().getDayList();
            JComboBox<Object> dayListField = new JComboBox<Object>(dayList.toArray());
            dayListField.setSelectedItem(this.match.getDay());
            int result = JOptionPane.showConfirmDialog(TravelingTournamentPanel.this.getRootPane(), dayListField, "Select day", 2);
            if (result == 0) {
                Day toDay = (Day)dayListField.getSelectedItem();
                DayChangeMove move = new DayChangeMove(this.match, toDay);
                TravelingTournamentPanel.this.solutionBusiness.doMove(move);
                TravelingTournamentPanel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class DayPanel
    extends JPanel {
        public DayPanel() {
            super(new GridLayout(1, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addMatch(Match match) {
            JButton button = new JButton(new MatchAction(match));
            this.add(button);
        }
    }
}

