/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.domain;

import java.io.Serializable;
import org.drools.testcoverage.domain.Customer;
import org.drools.testcoverage.domain.Drink;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.PropertyReactive;

@PropertyReactive
public class Order
implements Serializable {
    private final Customer customer;
    private final Drink drink;
    private Boolean approved;

    public Order(Customer customer, Drink drink) {
        this.customer = customer;
        this.drink = drink;
    }

    @Modifies(value={"approved"})
    public void approve() {
        this.approved = true;
    }

    @Modifies(value={"approved"})
    public void disapprove() {
        this.approved = false;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Drink getDrink() {
        return this.drink;
    }

    public Boolean isApproved() {
        return this.approved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        if (this.customer != null ? !this.customer.equals(order.customer) : order.customer != null) {
            return false;
        }
        if (this.drink != null ? !this.drink.equals(order.drink) : order.drink != null) {
            return false;
        }
        return !(this.approved == null ? order.approved != null : !this.approved.equals(order.approved));
    }

    public int hashCode() {
        int result = this.customer != null ? this.customer.hashCode() : 0;
        result = 31 * result + (this.drink != null ? this.drink.hashCode() : 0);
        result = 31 * result + (this.approved != null ? this.approved.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Order{customer=" + this.customer + ", drink=" + this.drink + ", approved=" + this.approved + '}';
    }
}

