/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;

public class TrackingAgendaEventListener
extends DefaultAgendaEventListener {
    private Map<String, Integer> rulesFired = new HashMap<String, Integer>();
    private List<String> rulesFiredOrder = new ArrayList<String>();

    public void afterMatchFired(AfterMatchFiredEvent event) {
        String rule = event.getMatch().getRule().getName();
        if (this.isRuleFired(rule)) {
            this.rulesFired.put(rule, this.rulesFired.get(rule) + 1);
        } else {
            this.rulesFired.put(rule, 1);
        }
        this.rulesFiredOrder.add(rule);
    }

    public boolean isRuleFired(String rule) {
        return this.rulesFired.containsKey(rule);
    }

    public int ruleFiredCount(String rule) {
        if (this.isRuleFired(rule)) {
            return this.rulesFired.get(rule);
        }
        return 0;
    }

    public int rulesCount() {
        return this.rulesFired.size();
    }

    public void clear() {
        this.rulesFired.clear();
    }

    public Collection<String> getFiredRules() {
        return this.rulesFired.keySet();
    }

    public List<String> getRulesFiredOrder() {
        return this.rulesFiredOrder;
    }
}

