/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

@RunWith(value=Parameterized.class)
public class QueryBadResultTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public QueryBadResultTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testQueriesWithSameNameInOneFile() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.kieBaseTestConfiguration, this.getClass(), false, "query-two-same-names.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testQueriesWithSameNameInTwoFiles() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.kieBaseTestConfiguration, this.getClass(), false, "query-same-name-1.drl", "query-same-name-2.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testQueryWithoutName() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.kieBaseTestConfiguration, this.getClass(), false, "query-without-name.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testQueryCalledWithoutParamsButItHasParams() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        try {
            ksession.getQueryResults("personWithName", new Object[0]);
            Assertions.fail((String)"invocation with wrong number of arguments must fail");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((boolean)e.getMessage().contains("wrong number of arguments")).isTrue();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAccessToNotExistingVariable() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        QueryResults results = ksession.getQueryResults("simple query with no parameters", new Object[0]);
        ((QueryResultsRow)results.iterator().next()).get("bad");
    }
}

