/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.template.DataProvider;
import org.drools.template.DataProviderCompiler;
import org.drools.template.ObjectDataCompiler;
import org.drools.template.objects.ArrayDataProvider;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TemplatesTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatesTest.class);
    private static final StringBuffer EXPECTED_RULES = new StringBuffer();
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TemplatesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void loadingFromDLRObjsCorrectnessCheck() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ArrayList<ParamSet> cfl = new ArrayList<ParamSet>();
        cfl.add(new ParamSet("tomato", "weight", 200, 1000, 6, EnumSet.of(Taste.GOOD, Taste.EXCELENT)));
        cfl.add(new ParamSet("cucumber", "length", 20, 40, 15, EnumSet.of(Taste.EXCELENT)));
        cfl.add(new ParamSet("carrot", "weight", 0, 1000, 2, EnumSet.of(Taste.HORRIBLE)));
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(cfl, resourceStream);
            LOGGER.debug(drl);
            TemplatesTest.assertEqualsIgnoreWhitespace(EXPECTED_RULES.toString(), drl);
            this.testCorrectnessCheck(drl);
        }
    }

    @Test
    public void loadingFromDLRMapsCorrectnessCheck() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(this.getMapsParam(), resourceStream);
            LOGGER.debug(drl);
            TemplatesTest.assertEqualsIgnoreWhitespace(EXPECTED_RULES.toString(), drl);
            this.testCorrectnessCheck(drl);
        }
    }

    @Test
    public void loadingFromDLRArrayCorrectnessCheck() throws Exception {
        String[][] rows = new String[3][6];
        rows[0] = new String[]{"tomato", "weight", "200", "1000", "6", "== Taste.GOOD || == Taste.EXCELENT"};
        rows[1] = new String[]{"cucumber", "length", "20", "40", "15", "== Taste.EXCELENT"};
        rows[2] = new String[]{"carrot", "weight", "0", "1000", "2", "== Taste.HORRIBLE"};
        ArrayDataProvider adp = new ArrayDataProvider(rows);
        DataProviderCompiler converter = new DataProviderCompiler();
        try (InputStream resourceStream = KieServices.Factory.get().getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile((DataProvider)adp, resourceStream);
            LOGGER.debug(drl);
            TemplatesTest.assertEqualsIgnoreWhitespace(EXPECTED_RULES.toString(), drl);
            this.testCorrectnessCheck(drl);
        }
    }

    @Test
    public void loadingFromDLRSpreadsheetCorrectnessCheck() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        KieServices kieServices = KieServices.Factory.get();
        try (InputStream spreadSheetStream = kieServices.getResources().newClassPathResource("template1_spreadsheet.drl.xls", this.getClass()).getInputStream();
             InputStream templateStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(spreadSheetStream, templateStream, 1, 1);
            LOGGER.debug(drl);
            TemplatesTest.assertEqualsIgnoreWhitespace(EXPECTED_RULES.toString(), drl);
            this.testCorrectnessCheck(drl);
        }
    }

    @Test(timeout=30000L)
    public void OneRuleManyRows() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ArrayList<ParamSet> cfl = new ArrayList<ParamSet>();
        cfl.add(new ParamSet("tomato", "weight", 200, 1000, 6, EnumSet.of(Taste.GOOD, Taste.EXCELENT)));
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(cfl, resourceStream);
            LOGGER.debug(drl);
            this.testManyRows(drl, 0, 1);
        }
    }

    @Test(timeout=30000L)
    public void TenRulesManyRows() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(this.generateParamSetCollection(1), resourceStream);
            LOGGER.debug(drl);
            this.testManyRows(drl, 500, 10);
        }
    }

    @Test(timeout=30000L)
    public void OneTemplateManyRules() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_1.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(this.generateParamSetCollection(5), resourceStream);
            LOGGER.debug(drl);
            this.testManyRules(drl, 50);
        }
    }

    @Test(timeout=30000L)
    public void TenTemplatesManyRules() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        ObjectDataCompiler converter = new ObjectDataCompiler();
        try (InputStream resourceStream = kieServices.getResources().newClassPathResource("template_2.drl", this.getClass()).getInputStream();){
            String drl = converter.compile(this.generateParamSetCollection(5), resourceStream);
            LOGGER.debug(drl);
            this.testManyRules(drl, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCorrectnessCheck(String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, drlResource);
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        try {
            session.setGlobal("list", list);
            session.insert((Object)new Vegetable("tomato", 350, 8, 3, Taste.GOOD));
            session.insert((Object)new Vegetable("tomato", 150, 8, 3, Taste.BAD));
            session.insert((Object)new Vegetable("tomato", 350, 8, 7, Taste.GOOD));
            session.insert((Object)new Vegetable("tomato", 1000, 8, 6, Taste.EXCELENT));
            session.insert((Object)new Vegetable("cucumber", 1500, 19, 5, Taste.EXCELENT));
            session.insert((Object)new Vegetable("cucumber", 1500, 21, 5, Taste.EXCELENT));
            session.insert((Object)new Vegetable("carrot", 1000, 8, 6, Taste.EXCELENT));
            session.insert((Object)new Vegetable("carrot", 200, 8, 1, Taste.HORRIBLE));
            session.insert((Object)new Vegetable("onion", 500, 7, 4, Taste.EXCELENT));
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Collection pkgs = kbase.getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(1);
        KiePackage pkg = (KiePackage)pkgs.iterator().next();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testManyRows(String drl, int expectedResultListSize, int expectedRulesCount) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, drlResource);
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        try {
            session.setGlobal("list", list);
            for (int i = 0; i < 500; ++i) {
                session.insert((Object)new Vegetable("tomato", 350, 8, 3, Taste.BAD));
            }
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
        Assertions.assertThat((int)list.size()).isEqualTo(expectedResultListSize);
        Collection pkgs = kbase.getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(1);
        KiePackage pkg = (KiePackage)pkgs.iterator().next();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(expectedRulesCount);
    }

    private void testManyRules(String drl, int expectedRulesCount) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, drlResource);
        Collection pkgs = kbase.getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(1);
        KiePackage pkg = (KiePackage)pkgs.iterator().next();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(expectedRulesCount);
    }

    private Collection<Map<String, Object>> getMapsParam() {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> mapTomato = new HashMap<String, Object>();
        mapTomato.put("name", "tomato");
        mapTomato.put("field", "weight");
        mapTomato.put("fieldLower", 200);
        mapTomato.put("fieldUpper", 1000);
        mapTomato.put("price", 6);
        mapTomato.put("tastes", "== Taste.GOOD || == Taste.EXCELENT");
        maps.add(mapTomato);
        HashMap<String, Object> mapCucumber = new HashMap<String, Object>();
        mapCucumber.put("name", "cucumber");
        mapCucumber.put("field", "length");
        mapCucumber.put("fieldLower", 20);
        mapCucumber.put("fieldUpper", 40);
        mapCucumber.put("price", 15);
        mapCucumber.put("tastes", "== Taste.EXCELENT");
        maps.add(mapCucumber);
        HashMap<String, Object> mapCarrot = new HashMap<String, Object>();
        mapCarrot.put("name", "carrot");
        mapCarrot.put("field", "weight");
        mapCarrot.put("fieldLower", 0);
        mapCarrot.put("fieldUpper", 1000);
        mapCarrot.put("price", 2);
        mapCarrot.put("tastes", "== Taste.HORRIBLE");
        maps.add(mapCarrot);
        return maps;
    }

    private Collection<ParamSet> generateParamSetCollection(int loops) {
        ArrayList<ParamSet> result = new ArrayList<ParamSet>();
        for (int i = 0; i < loops; ++i) {
            result.add(new ParamSet("tomato", "weight", 200, 1000 + i, 6, EnumSet.of(Taste.GOOD, Taste.EXCELENT)));
            result.add(new ParamSet("tomato", "weight", 100, 500 + i, 6, EnumSet.of(Taste.BAD)));
            result.add(new ParamSet("tomato", "length", 5, 10 + i, 6, EnumSet.of(Taste.AVERAGE)));
            result.add(new ParamSet("tomato", "weight", 300, 4000 + i, 6, EnumSet.of(Taste.GOOD, Taste.EXCELENT)));
            result.add(new ParamSet("tomato", "weight", 200, 6000 + i, 6, EnumSet.of(Taste.EXCELENT)));
            result.add(new ParamSet("tomato", "length", 2, 4 + i, 6, EnumSet.of(Taste.AVERAGE, Taste.GOOD)));
            result.add(new ParamSet("tomato", "weight", 100, 1000 + i, 6, EnumSet.of(Taste.GOOD)));
            result.add(new ParamSet("tomato", "weight", 500, 1000 + i, 6, EnumSet.of(Taste.EXCELENT)));
            result.add(new ParamSet("tomato", "length", 4, 15 + i, 6, EnumSet.of(Taste.AVERAGE, Taste.EXCELENT)));
            result.add(new ParamSet("tomato", "weight", 200, 1000 + i, 6, EnumSet.of(Taste.GOOD, Taste.EXCELENT)));
        }
        return result;
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    static {
        String head = "package org.drools.testcoverage.functional;\nimport  " + TemplatesTest.class.getCanonicalName() + ".Vegetable;\nimport  " + TemplatesTest.class.getCanonicalName() + ".Taste;\nglobal java.util.List list;\n\n";
        String rule2_when = "rule \"is appropriate 2\"\n\twhen\n\t\tVegetable( $name : name == \"carrot\", $field : weight >= 0 && <= 1000, $price : price <= 2, $taste : taste  == Taste.HORRIBLE )\n";
        String rule2_then = "\tthen\n\t\tlist.add( $name );\nend\n\n";
        String rule1_when = "rule \"is appropriate 1\"\n\twhen\n\t\tVegetable( $name : name == \"cucumber\", $field : length >= 20 && <= 40, $price : price <= 15, $taste : taste  == Taste.EXCELENT )\n";
        String rule1_then = "\tthen\n\t\tlist.add( $name );\nend\n\n";
        String rule0_when = "rule \"is appropriate 0\"\n\twhen\n\t\tVegetable( $name : name == \"tomato\", $field : weight >= 200 && <= 1000, $price : price <= 6, $taste : taste  == Taste.GOOD || == Taste.EXCELENT )\n";
        String rule0_then = "\tthen\n\t\tlist.add( $name );\nend\n\n";
        EXPECTED_RULES.append(head);
        EXPECTED_RULES.append("rule \"is appropriate 0\"\n\twhen\n\t\tVegetable( $name : name == \"tomato\", $field : weight >= 200 && <= 1000, $price : price <= 6, $taste : taste  == Taste.GOOD || == Taste.EXCELENT )\n").append("\tthen\n\t\tlist.add( $name );\nend\n\n");
        EXPECTED_RULES.append("rule \"is appropriate 1\"\n\twhen\n\t\tVegetable( $name : name == \"cucumber\", $field : length >= 20 && <= 40, $price : price <= 15, $taste : taste  == Taste.EXCELENT )\n").append("\tthen\n\t\tlist.add( $name );\nend\n\n");
        EXPECTED_RULES.append("rule \"is appropriate 2\"\n\twhen\n\t\tVegetable( $name : name == \"carrot\", $field : weight >= 0 && <= 1000, $price : price <= 2, $taste : taste  == Taste.HORRIBLE )\n").append("\tthen\n\t\tlist.add( $name );\nend\n\n");
    }

    public static class ParamSet {
        private String name;
        private String field;
        private int fieldLower;
        private int fieldUpper;
        private int price;
        private EnumSet<Taste> tasteSet;

        public ParamSet(String name, String field, int fieldLower, int fieldUpper, int price, EnumSet<Taste> tasteSet) {
            this.name = name;
            this.field = field;
            this.fieldLower = fieldLower;
            this.fieldUpper = fieldUpper;
            this.tasteSet = tasteSet;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public String getField() {
            return this.field;
        }

        public int getFieldLower() {
            return this.fieldLower;
        }

        public int getFieldUpper() {
            return this.fieldUpper;
        }

        public int getPrice() {
            return this.price;
        }

        public String getTastes() {
            StringBuilder sb = new StringBuilder();
            String conn = "";
            for (Taste t : this.tasteSet) {
                sb.append(conn).append(" == Taste.").append((Object)t);
                conn = " ||";
            }
            return sb.toString();
        }
    }

    public static enum Taste {
        HORRIBLE,
        BAD,
        AVERAGE,
        GOOD,
        EXCELENT;

    }

    public class Vegetable {
        private String name;
        private int weight;
        private int length;
        private int price;
        private Taste taste;

        public Vegetable(String name, int weight, int length, int price, Taste taste) {
            this.name = name;
            this.weight = weight;
            this.length = length;
            this.taste = taste;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getPrice() {
            return this.price;
        }

        public int getLength() {
            return this.length;
        }

        public Taste getTaste() {
            return this.taste;
        }
    }
}

