/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.oopath;

import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.InternationalAddress;
import org.drools.testcoverage.common.model.Person;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class OOPathDslTest {
    @Test
    public void dslWithOOPathAndSpecialChars() {
        String dsl = "[when]Person comes from \"{state}\"=person : Person( /address#InternationalAddress[ state == \"{state}\" ] )\n";
        String drl = "package P\n\nimport org.drools.testcoverage.common.model.InternationalAddress\nimport org.drools.testcoverage.common.model.Person\n\nrule R\nwhen\n    Person comes from \"Peaceful State\"\nthen\nend";
        KieSession kieSession = new KieHelper().addContent("[when]Person comes from \"{state}\"=person : Person( /address#InternationalAddress[ state == \"{state}\" ] )\n", ResourceType.DSL).addContent("package P\n\nimport org.drools.testcoverage.common.model.InternationalAddress\nimport org.drools.testcoverage.common.model.Person\n\nrule R\nwhen\n    Person comes from \"Peaceful State\"\nthen\nend", ResourceType.DSLR).build(new KieBaseOption[0]).newKieSession();
        Person person = new Person("Bruno", 21);
        person.setAddress(new InternationalAddress("Some Street", 10, "Beautiful City", "Peaceful State"));
        kieSession.insert((Object)person);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }
}

