/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class GenericsWithModifyTest {
    private static final String DRL = "package defaultKBase;\nimport java.util.Map;\nimport java.util.HashMap;\nrule R no-loop when\n $s : String( )\nthen\n Map<String,String> a = new HashMap<String,String>();\n modify( $s ) { };\nend\n";
    private KieSession kieSession;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GenericsWithModifyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Before
    public void initialize() {
        KieBuilder kbuilder = KieUtil.getKieBuilderFromDrls(this.kieBaseTestConfiguration, true, DRL);
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId());
        this.kieSession = kieContainer.newKieSession();
    }

    @After
    public void dispose() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testModifyWithGenericsOnRHS() {
        this.kieSession.insert((Object)"1");
        this.kieSession.fireAllRules();
    }
}

