/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class InaccurateComparisonTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public InaccurateComparisonTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testStringCoercionComparison() {
        String rule = "package org.drools.testcoverage.regression\n import org.drools.testcoverage.common.model.Message;\n rule \"string coercion\" \n when\n     m : Message( message < \"90201304122000000000000017\" )\n then \n end";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, "package org.drools.testcoverage.regression\n import org.drools.testcoverage.common.model.Message;\n rule \"string coercion\" \n when\n     m : Message( message < \"90201304122000000000000017\" )\n then \n end");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Message("90201304122000000000000015"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }
}

