/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.Promotion;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;

public class LogicalInsertionsSerializationTest
extends KieSessionTest {
    private static final String DRL_FILE = "logical-insertion.drl";
    @Rule
    public TestName name = new TestName();

    public LogicalInsertionsSerializationTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndStatefulKieSessionConfigurations();
    }

    @Test
    public void testSerializeAndDeserializeSession() throws Exception {
        Marshaller marshaller;
        KieSession ksession = this.session.getStateful();
        File tempFile = File.createTempFile(this.name.getMethodName(), null);
        ksession.fireAllRules();
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            marshaller = KieUtil.getServices().getMarshallers().newMarshaller(this.getKbase());
            marshaller.marshall((OutputStream)fos, ksession);
        }
        try (FileInputStream fis = new FileInputStream(tempFile);){
            marshaller = KieUtil.getServices().getMarshallers().newMarshaller(this.getKbase());
            marshaller.unmarshall((InputStream)fis, ksession);
        }
        ksession.insert((Object)new Promotion("Claire", "Scientist"));
        int firedRules = ksession.fireAllRules();
        Assertions.assertThat((int)firedRules).isEqualTo(1);
    }

    private KieBase getKbase() {
        return this.session.isStateful() ? this.session.getStateful().getKieBase() : this.session.getStateless().getKieBase();
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL_FILE, LogicalInsertionsSerializationTest.class);
    }
}

