/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class UnwantedStringConversionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnwantedStringConversionTest.class);
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public UnwantedStringConversionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testStringToDecimalConversion() {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("unwantedStringConversionTest.drl", this.getClass());
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromResources("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drlResource);
        KieSession ksession = kieBase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        Message message = new Message();
        SomeEntity someEntity = new SomeEntity("1.5");
        message.setSomeEntity(someEntity);
        message.setMessage("1.5");
        ksession.insert((Object)message);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("R1")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("R2")).isFalse();
        Assertions.assertThat((int)listener.rulesCount()).isEqualTo(0);
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private SomeEntity someEntity;
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setSomeEntity(SomeEntity someEntity) {
            this.someEntity = someEntity;
        }

        public SomeEntity getSomeEntity() {
            return this.someEntity;
        }
    }

    public static class SomeEntity {
        private String someString;

        public SomeEntity() {
        }

        public SomeEntity(String someString) {
            this.someString = someString;
        }

        public void setSomeString(String someString) {
            this.someString = someString;
        }

        public String getSomeString() {
            return this.someString;
        }

        public void customMethod() {
            LOGGER.debug("executing customMethod");
        }
    }
}

