/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.droolsassert.util.PatternProcessor;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class MvelProcessor
extends PatternProcessor {
    private static final String PATTERN = "\\$\\$\\{(?<long>(?!.*?\\$\\{).*?)\\}\\$|\\$\\{(?<short>(?!.*?\\$\\{).*?)\\}";
    protected final ParserContext parserContext;
    protected volatile Map<String, Object> executionContext = this.executionContext();

    public MvelProcessor() {
        super(PATTERN);
        try {
            this.parserContext = this.parserContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create parser context ", e);
        }
    }

    public void importPackage(String packageName) {
        this.parserContext.addPackageImport(packageName);
    }

    public Object define(String name, Object value) {
        return this.executionContext.put(name, value);
    }

    public void reset() {
        this.executionContext = this.executionContext();
    }

    @Override
    protected String resolve(Matcher matcher) {
        String expression = (String)StringUtils.defaultIfEmpty((CharSequence)matcher.group("long"), (CharSequence)matcher.group("short"));
        return String.valueOf(this.executionContext.containsKey(expression) ? this.executionContext.get(expression) : this.evaluate(expression));
    }

    public <T> T evaluate(String expression) {
        try {
            return (T)MVEL.executeExpression((Object)MVEL.compileExpression((String)expression, (ParserContext)this.parserContext), this.executionContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot evaluate " + expression, e);
        }
    }

    protected Map<String, Object> executionContext() {
        return new HashMap<String, Object>();
    }

    protected ParserContext parserContext() throws Exception {
        return new ParserContext();
    }
}

