/*
 * Decompiled with CFR 0.152.
 */
package org.droolsassert;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.droolsassert.util.AlphanumComparator;
import org.droolsassert.util.PerfStat;
import org.droolsassert.util.Stat;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;

public class RulesChronoAgendaEventListener
extends DefaultAgendaEventListener {
    protected final ConcurrentHashMap<String, PerfStat> rulesStat = new ConcurrentHashMap();
    protected final long aggregationPeriodMs;
    protected String sessionPrefix;
    protected boolean usePackageName;

    public RulesChronoAgendaEventListener() {
        this(PerfStat.getDefaultAggregationPeriodMs());
    }

    public RulesChronoAgendaEventListener(long aggregationPeriodMs) {
        this.aggregationPeriodMs = aggregationPeriodMs;
    }

    public RulesChronoAgendaEventListener withPackageName(boolean usePackageName) {
        this.usePackageName = usePackageName;
        return this;
    }

    public RulesChronoAgendaEventListener withSessionPrefix(String sessionPrefix) {
        this.sessionPrefix = sessionPrefix;
        return this;
    }

    public TreeMap<String, Stat> getPerfStat() {
        TreeMap<String, Stat> result = new TreeMap<String, Stat>(AlphanumComparator.ALPHANUM_COMPARATOR);
        for (Map.Entry<String, PerfStat> e : this.rulesStat.entrySet()) {
            result.put(e.getKey(), e.getValue().getStat());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        String ruleName = this.uniqueRuleName(event.getMatch().getRule());
        PerfStat ruleStat = this.rulesStat.get(ruleName);
        if (ruleStat == null) {
            ConcurrentHashMap<String, PerfStat> concurrentHashMap = this.rulesStat;
            synchronized (concurrentHashMap) {
                if (ruleStat == null) {
                    ruleStat = new PerfStat(this.sessionPrefix, ruleName, this.aggregationPeriodMs);
                    this.rulesStat.put(ruleName, ruleStat);
                }
            }
        }
        ruleStat.start();
    }

    private String uniqueRuleName(Rule rule) {
        StringBuilder sb = new StringBuilder();
        if (this.usePackageName) {
            sb.append(rule.getPackageName());
            sb.append(".");
        }
        sb.append(rule.getName());
        return sb.toString();
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        this.rulesStat.get(this.uniqueRuleName(event.getMatch().getRule())).stop();
    }

    public void reset() {
        this.rulesStat.values().forEach(PerfStat::reset);
    }
}

