/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.callstack.environment.CallFrameHelper;
import org.apache.cocoon.servletservice.AbstractServletConnection;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.util.ServletServiceRequest;
import org.apache.cocoon.servletservice.util.ServletServiceResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class AbsoluteServletConnection
extends AbstractServletConnection {
    public static String ABSOLUTE_SERVLET_SOURCE_POSTFIX = "+";
    private Servlet servlet;

    public AbsoluteServletConnection(String serviceName, String path, String queryString) {
        if (serviceName == null) {
            throw new IllegalArgumentException("The serviceName parameter must be passed.");
        }
        this.context = CallStackHelper.getBaseServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.context);
        try {
            this.servlet = (Servlet)applicationContext.getBean(serviceName);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("The service '" + serviceName + "' is not of type " + Servlet.class.getName() + ".");
        }
        if (this.servlet == null) {
            throw new IllegalArgumentException("The service '" + serviceName + "' does not exist.");
        }
        URI reqUri = null;
        try {
            this.uri = new URI(serviceName + ABSOLUTE_SERVLET_SOURCE_POSTFIX, null, path, queryString, null);
            this.uri = new URI("servlet", this.uri.toASCIIString(), null);
            reqUri = new URI("servlet", null, path, queryString, null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Can't create a URI using the passed path '" + path + "' and query string '" + queryString + "' values.");
            iae.initCause(e);
            throw iae;
        }
        this.request = new ServletServiceRequest(reqUri, CallFrameHelper.getRequest());
        this.response = new ServletServiceResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performConnect() throws ServletException, IOException {
        try {
            CallStackHelper.enterServlet(this.context, this.request, this.response);
            this.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
        }
        finally {
            CallStackHelper.leaveServlet();
        }
    }
}

