/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.servletservice.spring.ServletFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServletDecorator
implements BeanDefinitionDecorator {
    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        String embeddedServletBeanName = this.registerEmbeddedServletBean(holder, ctx);
        return this.createServletFactoryBeanDefinition((Element)source, holder, ctx, embeddedServletBeanName);
    }

    private String registerEmbeddedServletBean(BeanDefinitionHolder holder, ParserContext ctx) {
        String beanName = holder.getBeanName() + "/embedded";
        AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
        ctx.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)definition);
        return beanName;
    }

    private BeanDefinitionHolder createServletFactoryBeanDefinition(Element source, BeanDefinitionHolder holder, ParserContext ctx, String embeddedServletBeanName) {
        String ns = source.getNamespaceURI();
        if (!source.hasAttribute("mount-path")) {
            throw new RuntimeException("The mount-path attribute is required.");
        }
        String mountPath = source.getAttribute("mount-path");
        if (!source.hasAttribute("context-path")) {
            throw new RuntimeException("The context-path attribute is required.");
        }
        String contextPath = source.getAttribute("context-path");
        Element initParamsElem = (Element)source.getElementsByTagNameNS(ns, "init-params").item(0);
        Element contextParamsElem = (Element)source.getElementsByTagNameNS(ns, "context-params").item(0);
        Element connectionsElem = (Element)source.getElementsByTagNameNS(ns, "connections").item(0);
        BeanDefinitionBuilder servletFactoryDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(ServletFactoryBean.class);
        servletFactoryDefBuilder.setSource(ctx.extractSource((Object)source));
        servletFactoryDefBuilder.addPropertyReference("embeddedServlet", embeddedServletBeanName);
        servletFactoryDefBuilder.setInitMethodName("init");
        servletFactoryDefBuilder.setDestroyMethodName("destroy");
        servletFactoryDefBuilder.addPropertyValue("serviceName", (Object)holder.getBeanName());
        servletFactoryDefBuilder.addPropertyValue("mountPath", (Object)mountPath);
        servletFactoryDefBuilder.addPropertyValue("contextPath", (Object)contextPath);
        if (initParamsElem != null) {
            Map initParams = ctx.getDelegate().parseMapElement(initParamsElem, null);
            servletFactoryDefBuilder.addPropertyValue("initParams", (Object)initParams);
        }
        if (contextParamsElem != null) {
            Map contextParams = ctx.getDelegate().parseMapElement(contextParamsElem, null);
            servletFactoryDefBuilder.addPropertyValue("contextParams", (Object)contextParams);
        }
        if (connectionsElem != null) {
            Map connections = ctx.getDelegate().parseMapElement(connectionsElem, null);
            servletFactoryDefBuilder.addPropertyValue("connections", (Object)connections);
            HashMap<String, String> connectionNames = new HashMap<String, String>();
            for (TypedStringValue key : connections.keySet()) {
                if (key.getValue().endsWith("+")) {
                    throw new InvalidBeanReferenceNameException("The key of a servlet connection mustn't use '+' as its last character. This is reserved for absolute references in servlet sources.");
                }
                RuntimeBeanReference beanNameReference = (RuntimeBeanReference)connections.get(key);
                connectionNames.put(key.getValue(), beanNameReference.getBeanName());
            }
            servletFactoryDefBuilder.addPropertyValue("connectionServiceNames", connectionNames);
        }
        return new BeanDefinitionHolder((BeanDefinition)servletFactoryDefBuilder.getBeanDefinition(), holder.getBeanName());
    }

    private class InvalidBeanReferenceNameException
    extends RuntimeException {
        public InvalidBeanReferenceNameException(String message) {
            super(message);
        }
    }
}

