/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.TextPieceTable;

public class ComplexFileTable {
    private static final byte GRPPRL_TYPE = 1;
    private static final byte TEXT_PIECE_TABLE_TYPE = 2;
    protected TextPieceTable _tpt;

    public ComplexFileTable(byte[] documentStream, byte[] tableStream, int offset, int fcMin) throws IOException {
        while (tableStream[offset] == 1) {
            short skip = LittleEndian.getShort((byte[])tableStream, (int)(++offset));
            offset += 2 + skip;
        }
        if (tableStream[offset] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        int pieceTableSize = LittleEndian.getInt((byte[])tableStream, (int)(++offset));
        this._tpt = new TextPieceTable(documentStream, tableStream, offset += 4, pieceTableSize, fcMin);
    }

    public TextPieceTable getTextPieceTable() {
        return this._tpt;
    }
}

