/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.ComplexFileTable;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordTextExtractor;
import org.textmining.extraction.word.WordTextScrubber;
import org.textmining.extraction.word.chp.Word6CHPBinTable;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.ComplexNodeHelper;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PieceDescriptor;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;

public class Word6TextExtractor
extends WordTextExtractor {
    Word6TextExtractor(byte[] header, boolean fastSave) {
        this._header = header;
        this._fastSave = fastSave;
    }

    protected Word6TextExtractor() {
    }

    public Word6TextExtractor(InputStream in) throws IOException, PasswordProtectedException {
        super.initWordHeader(in);
    }

    @Override
    protected boolean isDeleted(byte[] grpprl) {
        int offset = 0;
        boolean deleted = false;
        while (offset < grpprl.length) {
            switch (LittleEndian.getUnsignedByte((byte[])grpprl, (int)offset++)) {
                case 65: {
                    deleted = grpprl[offset++] != 0;
                    break;
                }
                case 66: {
                    ++offset;
                    break;
                }
                case 67: {
                    ++offset;
                    break;
                }
                case 68: {
                    offset += grpprl[offset];
                    break;
                }
                case 69: {
                    offset += 2;
                    break;
                }
                case 70: {
                    offset += 4;
                    break;
                }
                case 71: {
                    ++offset;
                    break;
                }
                case 72: {
                    offset += 2;
                    break;
                }
                case 73: {
                    offset += 3;
                    break;
                }
                case 74: {
                    offset += grpprl[offset];
                    break;
                }
                case 75: {
                    ++offset;
                    break;
                }
                case 80: {
                    offset += 2;
                    break;
                }
                case 81: {
                    offset += grpprl[offset];
                    break;
                }
                case 82: {
                    offset += grpprl[offset];
                    break;
                }
                case 83: {
                    break;
                }
                case 85: {
                    ++offset;
                    break;
                }
                case 86: {
                    ++offset;
                    break;
                }
                case 87: {
                    ++offset;
                    break;
                }
                case 88: {
                    ++offset;
                    break;
                }
                case 89: {
                    ++offset;
                    break;
                }
                case 90: {
                    ++offset;
                    break;
                }
                case 91: {
                    ++offset;
                    break;
                }
                case 92: {
                    ++offset;
                    break;
                }
                case 93: {
                    offset += 2;
                    break;
                }
                case 94: {
                    ++offset;
                    break;
                }
                case 95: {
                    offset += 3;
                    break;
                }
                case 96: {
                    offset += 2;
                    break;
                }
                case 97: {
                    offset += 2;
                    break;
                }
                case 98: {
                    ++offset;
                    break;
                }
                case 99: {
                    ++offset;
                    break;
                }
                case 100: {
                    ++offset;
                    break;
                }
                case 101: {
                    ++offset;
                    break;
                }
                case 102: {
                    ++offset;
                    break;
                }
                case 103: {
                    offset += grpprl[offset];
                    break;
                }
                case 104: {
                    ++offset;
                    break;
                }
                case 105: {
                    offset += grpprl[offset];
                    break;
                }
                case 106: {
                    offset += grpprl[offset];
                    break;
                }
                case 107: {
                    offset += 2;
                    break;
                }
                case 108: {
                    offset += grpprl[offset];
                    break;
                }
                case 109: {
                    offset += 2;
                    break;
                }
                case 110: {
                    offset += 2;
                    break;
                }
                case 117: {
                    ++offset;
                    break;
                }
                case 118: {
                    ++offset;
                }
            }
        }
        return deleted;
    }

    @Override
    public String getText() throws IOException {
        StringWriter writer = new StringWriter();
        this.getText(writer);
        return writer.toString();
    }

    @Override
    public void getText(Writer writer) throws IOException {
        int fcMin = LittleEndian.getInt((byte[])this._header, (int)24);
        int fcMax = LittleEndian.getInt((byte[])this._header, (int)28);
        int chpTableOffset = this.getChpTableOffset();
        int chpTableSize = this.getChpTableSize();
        NodeHelper fc2Cp = null;
        StringBuffer allTxt = new StringBuffer();
        if (this._fastSave) {
            int complexOffset = this.getComplexOffset();
            ComplexFileTable cft = new ComplexFileTable(this._header, this._header, complexOffset, fcMin);
            TextPieceTable tpt = cft.getTextPieceTable();
            fc2Cp = new ComplexNodeHelper(tpt);
            List textPieces = tpt.getTextPieces();
            for (int x = 0; x < textPieces.size(); ++x) {
                TextPiece tp = (TextPiece)textPieces.get(x);
                tp.getPieceDescriptor().setUnicode(false);
                String txt = tp.getText(this._header);
                allTxt.append(txt);
            }
        } else {
            PieceDescriptor pd = new PieceDescriptor();
            pd.setFilePosition(fcMin);
            TextPieceTable tpt = new TextPieceTable();
            TextPiece tp = new TextPiece(0, fcMax - fcMin, pd);
            tpt.getTextPieces().add(tp);
            fc2Cp = new NodeHelper(tpt);
            allTxt.append(tp.getText(this._header));
        }
        Word6CHPBinTable chpTable = new Word6CHPBinTable(this._header, chpTableOffset, chpTableSize, fcMin, fc2Cp);
        List textRuns = chpTable.getTextRuns();
        WordTextScrubber scrubber = new WordTextScrubber();
        for (int x = 0; x < textRuns.size(); ++x) {
            CHPX chpx = (CHPX)textRuns.get(x);
            if (this.isDeleted(chpx.getGrpprl())) continue;
            String str = allTxt.substring(chpx.getStart(), chpx.getEnd());
            scrubber.append(writer, str);
        }
    }

    protected int getChpTableSize() {
        return LittleEndian.getInt((byte[])this._header, (int)188);
    }

    protected int getChpTableOffset() {
        return LittleEndian.getInt((byte[])this._header, (int)184);
    }

    protected int getComplexOffset() {
        return LittleEndian.getInt((byte[])this._header, (int)352);
    }
}

