/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.CHPFormattedDiskPage;
import org.textmining.extraction.word.model.GenericPropertyNode;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PlexOfCps;

public class CHPBinTable {
    protected ArrayList _textRuns = new ArrayList();

    public CHPBinTable() {
    }

    public CHPBinTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, NodeHelper fc2Cp) {
        PlexOfCps binTable = new PlexOfCps(tableStream, offset, size, 4);
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getInt((byte[])node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, fcMin, fc2Cp);
            int fkpSize = cfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                this._textRuns.add(cfkp.getCHPX(y));
            }
        }
        fc2Cp.sortNodes(this._textRuns, false);
    }

    public List getTextRuns() {
        return this._textRuns;
    }
}

