/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.List;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.PropertyNode;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;

public class NodeHelper {
    List _textPieces;
    int _lastTxtPiece;
    int _fcMin;

    public NodeHelper(TextPieceTable tpt) {
        this._textPieces = tpt.getTextPieces();
        this._fcMin = ((TextPiece)this._textPieces.get(0)).getPieceDescriptor().getFilePosition();
        this._lastTxtPiece = 0;
    }

    private boolean setCpRange(PropertyNode node) {
        int fcStart = Math.max(node.getStart(), this._fcMin);
        int fcEnd = node.getEnd();
        while (this._lastTxtPiece < this._textPieces.size()) {
            TextPiece tp = (TextPiece)this._textPieces.get(this._lastTxtPiece);
            int pieceFcStart = tp.getFcStart();
            int pieceFcEnd = tp.getFcEnd();
            if (fcStart >= pieceFcStart && fcStart < pieceFcEnd) {
                int divisor = tp.unicode() ? 2 : 1;
                int cpStart = tp.getStart() + (fcStart - pieceFcStart) / divisor;
                int cpEnd = cpStart + (fcEnd - fcStart) / divisor;
                node.setStart(cpStart);
                node.setEnd(cpEnd);
                return true;
            }
            ++this._lastTxtPiece;
        }
        return false;
    }

    public void addChpNodes(List nodes, byte[] grpprl, int fcStart, int fcEnd) {
        CHPX chpx = new CHPX(fcStart, fcEnd, grpprl);
        if (this.setCpRange(chpx)) {
            nodes.add(chpx);
        }
    }

    public void sortNodes(List nodes, boolean paragraphs) {
    }
}

