/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.textmining.extraction.word.model.GenericPropertyNode;
import org.textmining.extraction.word.model.PieceDescriptor;
import org.textmining.extraction.word.model.PlexOfCps;
import org.textmining.extraction.word.model.TextPiece;

public class TextPieceTable {
    protected ArrayList _textPieces = new ArrayList();

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin) throws UnsupportedEncodingException {
        PlexOfCps pieceTable = new PlexOfCps(tableStream, offset, size, PieceDescriptor.getSizeInBytes());
        int length = pieceTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = pieceTable.getProperty(x);
            PieceDescriptor piece = new PieceDescriptor(node.getBytes(), 0);
            int fcStart = piece.getFilePosition();
            int fcEnd = fcStart + (node.getEnd() - node.getStart()) * (piece.isUnicode() ? 2 : 1);
            this._textPieces.add(new TextPiece(node.getStart(), node.getEnd(), piece));
        }
    }

    public List getTextPieces() {
        return this._textPieces;
    }
}

