/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSIndexer;

public class MediaFilterManager {
    public static boolean updateIndex = true;
    public static boolean isVerbose = false;
    public static boolean isForce = false;
    public static String identifier = null;
    public static int max2Process = Integer.MAX_VALUE;
    public static int processed = 0;
    private static MediaFilter[] filterClasses = null;
    private static Map filterFormats = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        System.setProperty("java.awt.headless", "true");
        PosixParser parser = new PosixParser();
        int status = 0;
        Options options = new Options();
        options.addOption("v", "verbose", false, "print all extracted text and other details to STDOUT");
        options.addOption("f", "force", false, "force all bitstreams to be processed");
        options.addOption("n", "noindex", false, "do NOT update the search index after filtering bitstreams");
        options.addOption("i", "identifier", true, "ONLY process bitstreams belonging to identifier");
        options.addOption("m", "maximum", true, "process no more than maximum items");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("MediaFilter\n", options);
            System.exit(0);
        }
        if (line.hasOption('v')) {
            isVerbose = true;
        }
        if (line.hasOption('n')) {
            updateIndex = false;
        }
        if (line.hasOption('f')) {
            isForce = true;
        }
        if (line.hasOption('i')) {
            identifier = line.getOptionValue('i');
        }
        if (line.hasOption('m') && (max2Process = Integer.parseInt(line.getOptionValue('m'))) <= 1) {
            System.out.println("Invalid maximum value '" + line.getOptionValue('m') + "' - ignoring");
            max2Process = Integer.MAX_VALUE;
        }
        filterClasses = (MediaFilter[])PluginManager.getPluginSequence(MediaFilter.class);
        for (int i = 0; i < filterClasses.length; ++i) {
            String filterName = filterClasses[i].getClass().getName();
            String formats = ConfigurationManager.getProperty("filter." + filterName + ".inputFormats");
            if (formats == null) continue;
            filterFormats.put(filterName, Arrays.asList(formats.split(",[\\s]*")));
        }
        Context c = null;
        try {
            c = new Context();
            c.setIgnoreAuthorization(true);
            if (identifier == null) {
                MediaFilterManager.applyFiltersAllItems(c);
            } else {
                DSpaceObject dso = HandleManager.resolveToObject(c, identifier);
                if (dso == null) {
                    throw new IllegalArgumentException("Cannot resolve " + identifier + " to a DSpace object");
                }
                switch (dso.getType()) {
                    case 4: {
                        MediaFilterManager.applyFiltersCommunity(c, (Community)dso);
                        break;
                    }
                    case 3: {
                        MediaFilterManager.applyFiltersCollection(c, (Collection)dso);
                        break;
                    }
                    case 2: {
                        MediaFilterManager.applyFiltersItem(c, (Item)dso);
                    }
                }
            }
            if (updateIndex) {
                System.out.println("Updating search index:");
                DSIndexer.updateIndex(c);
            }
            c.complete();
            c = null;
        }
        catch (Exception e) {
            status = 1;
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
        System.exit(status);
    }

    public static void applyFiltersAllItems(Context c) throws Exception {
        ItemIterator i = Item.findAll(c);
        while (i.hasNext() && processed < max2Process) {
            MediaFilterManager.applyFiltersItem(c, i.next());
        }
    }

    public static void applyFiltersCommunity(Context c, Community community) throws Exception {
        Community[] subcommunities = community.getSubcommunities();
        for (int i = 0; i < subcommunities.length; ++i) {
            MediaFilterManager.applyFiltersCommunity(c, subcommunities[i]);
        }
        Collection[] collections = community.getCollections();
        for (int j = 0; j < collections.length; ++j) {
            MediaFilterManager.applyFiltersCollection(c, collections[j]);
        }
    }

    public static void applyFiltersCollection(Context c, Collection collection) throws Exception {
        ItemIterator i = collection.getItems();
        while (i.hasNext() && processed < max2Process) {
            MediaFilterManager.applyFiltersItem(c, i.next());
        }
    }

    public static void applyFiltersItem(Context c, Item item) throws Exception {
        if (MediaFilterManager.filterItem(c, item)) {
            c.commit();
            ++processed;
        }
        item.decache();
    }

    public static boolean filterItem(Context c, Item myItem) throws Exception {
        Bundle[] myBundles = myItem.getBundles("ORIGINAL");
        boolean done = false;
        for (int i = 0; i < myBundles.length; ++i) {
            Bitstream[] myBitstreams = myBundles[i].getBitstreams();
            for (int k = 0; k < myBitstreams.length; ++k) {
                done |= MediaFilterManager.filterBitstream(c, myItem, myBitstreams[k]);
            }
        }
        return done;
    }

    public static boolean filterBitstream(Context c, Item myItem, Bitstream myBitstream) throws Exception {
        boolean filtered = false;
        for (int i = 0; i < filterClasses.length; ++i) {
            List fmts = (List)filterFormats.get(filterClasses[i].getClass().getName());
            if (!fmts.contains(myBitstream.getFormat().getShortDescription())) continue;
            try {
                if (!filterClasses[i].processBitstream(c, myItem, myBitstream)) continue;
                myItem.update();
                filtered = true;
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR filtering, skipping bitstream #" + myBitstream.getID() + " " + e);
                e.printStackTrace();
            }
        }
        return filtered;
    }
}

