/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PDFFilter
extends MediaFilter {
    private static Logger log = Logger.getLogger(PDFFilter.class);

    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    public String getBundleName() {
        return "TEXT";
    }

    public String getFormatString() {
        return "Text";
    }

    public String getDescription() {
        return "Extracted text";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getDestinationStream(InputStream source) throws Exception {
        PDFTextStripper pts = new PDFTextStripper();
        PDFParser parser = null;
        String extractedText = null;
        try {
            parser = new PDFParser(source);
            parser.parse();
            extractedText = pts.getText(new PDDocument(parser.getDocument()));
        }
        finally {
            try {
                parser.getDocument().close();
            }
            catch (Exception e) {
                log.error((Object)("Error closing temporary PDF file: " + e.getMessage()), (Throwable)e);
            }
        }
        if (MediaFilterManager.isVerbose) {
            System.out.println(extractedText);
        }
        byte[] textBytes = extractedText.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(textBytes);
        return bais;
    }
}

