/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.dspace.app.sitemap.AbstractGenerator;

public class HTMLSitemapGenerator
extends AbstractGenerator {
    private String indexURLStem;
    private String indexURLTail;

    public HTMLSitemapGenerator(File outputDirIn, String urlStem, String urlTail) {
        super(outputDirIn);
        this.indexURLStem = urlStem;
        this.indexURLTail = urlTail == null ? "" : urlTail;
    }

    public String getFilename(int number) {
        return "sitemap" + number + ".html";
    }

    public String getLeadingBoilerPlate() {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<HTML><HEAD><TITLE>URL List</TITLE></HEAD><BODY><UL>";
    }

    public int getMaxSize() {
        return 51200;
    }

    public int getMaxURLs() {
        return 1000;
    }

    public String getTrailingBoilerPlate() {
        return "</UL></BODY></HTML>\n";
    }

    public String getURLText(String url, Date lastMod) {
        StringBuffer urlText = new StringBuffer();
        urlText.append("<LI><A HREF=\"").append(url).append("\">").append(url).append("</A></LI>");
        return urlText.toString();
    }

    public boolean useCompression() {
        return false;
    }

    public String getIndexFilename() {
        return "sitemap_index.html";
    }

    public void writeIndex(PrintStream output, int sitemapCount) throws IOException {
        output.println(this.getLeadingBoilerPlate());
        for (int i = 0; i < sitemapCount; ++i) {
            output.print("<A HREF=\"" + this.indexURLStem + i + this.indexURLTail + "\">sitemap " + i);
            output.print("</A></LI>");
        }
        output.println(this.getTrailingBoilerPlate());
    }
}

