/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class X509Authentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(X509Authentication.class);
    private static PublicKey caPublicKey = null;
    private static KeyStore caCertKeyStore = null;

    private static String getEmail(X509Certificate certificate) throws SQLException {
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            return null;
        }
        String dn = principal.getName();
        if (dn == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            int len = "emailaddress=".length();
            token = tokenizer.nextToken();
            if (!token.toLowerCase().startsWith("emailaddress=")) continue;
            if (token.length() <= len) {
                return null;
            }
            return token.substring(len).toLowerCase();
        }
        return null;
    }

    private static boolean isValid(Context context, X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        try {
            certificate.checkValidity();
        }
        catch (CertificateException e) {
            log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate is EXPIRED or PREMATURE: " + e.toString()));
            return false;
        }
        if (caPublicKey != null) {
            try {
                certificate.verify(caPublicKey);
                return true;
            }
            catch (GeneralSecurityException e) {
                log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        if (caCertKeyStore != null) {
            try {
                Enumeration<String> ke = caCertKeyStore.aliases();
                while (ke.hasMoreElements()) {
                    String alias = ke.nextElement();
                    if (!caCertKeyStore.isCertificateEntry(alias)) continue;
                    Certificate ca = caCertKeyStore.getCertificate(alias);
                    try {
                        certificate.verify(ca.getPublicKey());
                        return true;
                    }
                    catch (CertificateException ce) {
                    }
                }
                log.info((Object)LogManager.getHeader(context, "authentication", "Keystore method FAILED SIGNATURE check on client cert."));
            }
            catch (GeneralSecurityException e) {
                log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        return false;
    }

    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return ConfigurationManager.getBooleanProperty("authentication.x509.autoregister");
    }

    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    public boolean isImplicit() {
        return true;
    }

    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        return new int[0];
    }

    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        X509Certificate[] certs = null;
        if (request != null) {
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length == 0) {
            return 5;
        }
        try {
            if (!X509Authentication.isValid(context, certs[0])) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=x509certificate, status=BAD_CREDENTIALS (not valid)"));
                return 2;
            }
            String email = X509Authentication.getEmail(certs[0]);
            EPerson eperson = null;
            if (email != null) {
                eperson = EPerson.findByEmail(context, email);
            }
            if (eperson == null) {
                if (email != null && this.canSelfRegister(context, request, null)) {
                    log.info((Object)LogManager.getHeader(context, "autoregister", "from=x.509, email=" + email));
                    context.setIgnoreAuthorization(true);
                    eperson = EPerson.create(context);
                    eperson.setEmail(email);
                    eperson.setCanLogIn(true);
                    AuthenticationManager.initEPerson(context, request, eperson);
                    eperson.update();
                    context.commit();
                    context.setIgnoreAuthorization(false);
                    context.setCurrentUser(eperson);
                    return 1;
                }
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=cert_but_no_record, cannot auto-register"));
                return 4;
            }
            if (!eperson.canLogIn()) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=x509certificate, email=" + email + ", canLogIn=false, rejecting."));
                return 5;
            }
            log.info((Object)LogManager.getHeader(context, "login", "type=x509certificate"));
            context.setCurrentUser(eperson);
            return 1;
        }
        catch (AuthorizeException ce) {
            log.warn((Object)LogManager.getHeader(context, "authorize_exception", ""), (Throwable)ce);
            return 5;
        }
    }

    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public String loginPageTitle(Context context) {
        return null;
    }

    static {
        String keystorePath = ConfigurationManager.getProperty("authentication.x509.keystore.path");
        String keystorePassword = ConfigurationManager.getProperty("authentication.x509.keystore.password");
        String caCertPath = ConfigurationManager.getProperty("authentication.x509.ca.cert");
        if (caCertPath == null) {
            caCertPath = ConfigurationManager.getProperty("webui.cert.ca");
        }
        if (keystorePath != null) {
            if (keystorePassword == null) {
                keystorePassword = "";
            }
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
                caCertKeyStore = ks;
            }
            catch (IOException e) {
                log.error((Object)("X509Authentication: Failed to load CA keystore, file=" + keystorePath + ", error=" + e.toString()));
            }
            catch (GeneralSecurityException e) {
                log.error((Object)("X509Authentication: Failed to extract CA keystore, file=" + keystorePath + ", error=" + e.toString()));
            }
        }
        if (caCertPath != null) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(caCertPath));
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                if (cert != null) {
                    caPublicKey = cert.getPublicKey();
                }
            }
            catch (IOException e) {
                log.error((Object)("X509Authentication: Failed to load CA cert, file=" + caCertPath + ", error=" + e.toString()));
            }
            catch (CertificateException e) {
                log.error((Object)("X509Authentication: Failed to extract CA cert, file=" + caCertPath + ", error=" + e.toString()));
            }
        }
    }
}

