/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowseOrder;
import org.dspace.browse.BrowserScope;
import org.dspace.browse.SortOption;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class BrowseEngine {
    private static Logger log = Logger.getLogger(BrowseEngine.class);
    private BrowserScope scope;
    private Context context;
    private BrowseDAO dao;
    private BrowseIndex browseIndex;

    public BrowseEngine(Context context) throws BrowseException {
        this.context = context;
        this.dao = BrowseDAOFactory.getInstance(context);
    }

    public BrowseInfo browse(BrowserScope bs) throws BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "browse", ""));
        this.scope = bs;
        this.browseIndex = this.scope.getBrowseIndex();
        if (this.browseIndex.isMetadataIndex() && !this.scope.isSecondLevel()) {
            return this.browseByValue(this.scope);
        }
        return this.browseByItem(this.scope);
    }

    public BrowseInfo browseMini(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_mini", ""));
        this.scope = bs;
        this.browseIndex = this.scope.getBrowseIndex();
        this.dao.setTable(this.browseIndex.getTableName(this.scope.inCommunity(), this.scope.inCollection()));
        this.dao.setAscending(this.scope.isAscending());
        if (this.scope.inCollection() || this.scope.inCommunity()) {
            if (this.scope.inCollection()) {
                Collection col = (Collection)this.scope.getBrowseContainer();
                this.dao.setContainerIDField("collection_id");
                this.dao.setContainerID(col.getID());
            } else if (this.scope.inCommunity()) {
                Community com = (Community)this.scope.getBrowseContainer();
                this.dao.setContainerIDField("community_id");
                this.dao.setContainerID(com.getID());
            }
        }
        this.dao.setLimit(this.scope.getResultsPerPage());
        String orderBy = this.browseIndex.getSortField();
        if (this.scope.getSortBy() > 0) {
            orderBy = "sort_" + Integer.toString(this.scope.getSortBy());
        }
        this.dao.setOrderField(orderBy);
        List results = this.dao.doQuery();
        BrowseInfo browseInfo = new BrowseInfo(results, 0, this.scope.getResultsPerPage(), 0);
        browseInfo.setBrowseIndex(this.browseIndex);
        browseInfo.setSortOption(this.scope.getSortOption());
        browseInfo.setAscending(this.scope.isAscending());
        if (this.scope.inCollection() || this.scope.inCommunity()) {
            browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
        }
        browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
        browseInfo.setEtAl(this.scope.getEtAl());
        return browseInfo;
    }

    private BrowseInfo browseByItem(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_by_item", ""));
        try {
            this.dao.setTable(this.browseIndex.getTableName(this.scope.inCommunity(), this.scope.inCollection()));
            this.dao.setAscending(this.scope.isAscending());
            String focusValue = null;
            String rawFocusValue = null;
            String focusField = this.browseIndex.getSortField();
            if (this.scope.hasJumpToItem() || this.scope.hasJumpToValue() || this.scope.hasStartsWith()) {
                rawFocusValue = focusValue = this.getJumpToValue();
                focusValue = this.normalizeJumpToValue(focusValue);
                if (this.scope.hasStartsWith() && this.browseIndex.isDate()) {
                    focusValue = focusValue + "-32";
                }
                log.debug((Object)("browsing using focus: " + focusValue));
                if (this.scope.getSortBy() > 0) {
                    focusField = "sort_" + Integer.toString(this.scope.getSortBy());
                }
                this.dao.setJumpToField(focusField);
                this.dao.setJumpToValue(focusValue);
            }
            String value = null;
            String rawValue = null;
            if (this.scope.hasFilterValue() && this.scope.isSecondLevel()) {
                rawValue = value = this.scope.getFilterValue();
                value = BrowseOrder.makeSortString(value, this.scope.getFilterValueLang(), this.scope.getBrowseIndex().getDataType());
                this.dao.setFilterValueField("sort_value");
                this.dao.setFilterValue(value);
            }
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                if (this.scope.inCollection()) {
                    Collection col = (Collection)this.scope.getBrowseContainer();
                    this.dao.setContainerIDField("collection_id");
                    this.dao.setContainerID(col.getID());
                } else if (this.scope.inCommunity()) {
                    Community com = (Community)this.scope.getBrowseContainer();
                    this.dao.setContainerIDField("community_id");
                    this.dao.setContainerID(com.getID());
                }
            }
            String orderBy = this.browseIndex.getSortField();
            if (this.scope.getSortBy() > 0) {
                orderBy = "sort_" + Integer.toString(this.scope.getSortBy());
            }
            this.dao.setOrderField(orderBy);
            this.dao.setLimit(this.scope.getResultsPerPage() + 1);
            List results = this.dao.doQuery();
            boolean showLast = false;
            if (results.size() == 0) {
                showLast = true;
            }
            BrowseItem next = null;
            int lastIndex = results.size() - 1;
            if (lastIndex >= this.scope.getResultsPerPage()) {
                next = (BrowseItem)results.get(lastIndex);
                results.remove(lastIndex);
            }
            BrowseItem prev = null;
            if (this.scope.hasJumpToItem() || this.scope.hasJumpToValue() || this.scope.hasStartsWith()) {
                int prevID = -1;
                prevID = showLast ? this.getPreviousPageID(results) : this.getPreviousPageID(null);
                if (prevID != -1) {
                    prev = bs.getBrowseIndex() == BrowseIndex.getWithdrawnBrowseIndex() ? new BrowseItem(this.context, prevID, false, true) : new BrowseItem(this.context, prevID, true, false);
                }
            }
            int offset = 0;
            int total = this.getTotalResults();
            int position = -1;
            if (total > 0) {
                if (showLast) {
                    position = total - this.scope.getResultsPerPage();
                    if (position < 0) {
                        position = 0;
                    }
                } else {
                    position = this.getPosition(false);
                }
            }
            BrowseInfo browseInfo = new BrowseInfo(results, position, total, offset);
            if (next != null) {
                browseInfo.setNextItem(next.getID());
            }
            if (prev != null) {
                browseInfo.setPrevItem(prev.getID());
            }
            browseInfo.setBrowseIndex(this.browseIndex);
            browseInfo.setSortOption(this.scope.getSortOption());
            browseInfo.setAscending(this.scope.isAscending());
            browseInfo.setBrowseLevel(this.scope.getBrowseLevel());
            browseInfo.setValue(rawValue);
            browseInfo.setFocus(rawFocusValue);
            if (this.scope.hasJumpToItem()) {
                browseInfo.setFocusItem(this.scope.getJumpToItem());
            }
            browseInfo.setStartsWith(this.scope.hasStartsWith());
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
            }
            browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
            browseInfo.setEtAl(this.scope.getEtAl());
            return browseInfo;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private BrowseInfo browseByValue(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_by_value", "focus=" + bs.getJumpToValue()));
        try {
            this.dao.setTable(this.browseIndex.getTableName(true, this.scope.inCommunity(), this.scope.inCollection()));
            this.dao.setDistinct(true);
            this.dao.setAscending(this.scope.isAscending());
            this.dao.setJumpToField("sort_value");
            String focusValue = null;
            String rawFocusValue = null;
            if (this.scope.hasJumpToValue() || this.scope.hasStartsWith()) {
                rawFocusValue = focusValue = this.getJumpToValue();
                focusValue = this.normalizeJumpToValue(focusValue);
                if (this.scope.hasStartsWith() && this.browseIndex.isDate()) {
                    focusValue = focusValue + "-32";
                }
                this.dao.setJumpToValue(focusValue);
            }
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                if (this.scope.inCollection()) {
                    Collection col = (Collection)this.scope.getBrowseContainer();
                    this.dao.setContainerTable(this.browseIndex.getTableName(false, true, false, true));
                    this.dao.setContainerIDField("collection_id");
                    this.dao.setContainerID(col.getID());
                } else if (this.scope.inCommunity()) {
                    Community com = (Community)this.scope.getBrowseContainer();
                    this.dao.setContainerTable(this.browseIndex.getTableName(true, false, false, true));
                    this.dao.setContainerIDField("community_id");
                    this.dao.setContainerID(com.getID());
                }
            }
            this.dao.setOrderField("sort_value");
            this.dao.setLimit(this.scope.getResultsPerPage() + 1);
            List results = this.dao.doValueQuery();
            boolean showLast = false;
            if (results.size() == 0) {
                showLast = true;
            }
            String next = null;
            int lastIndex = results.size() - 1;
            if (lastIndex >= this.scope.getResultsPerPage()) {
                next = (String)results.get(lastIndex);
                results.remove(lastIndex);
            }
            String prev = null;
            if (this.scope.hasJumpToValue() || this.scope.hasStartsWith()) {
                prev = showLast ? this.getPreviousPageValue(results) : this.getPreviousPageValue(null);
            }
            int offset = 0;
            int total = this.getTotalResults(true);
            int position = this.getPosition(true);
            BrowseInfo browseInfo = new BrowseInfo(results, position, total, offset);
            if (next != null) {
                browseInfo.setNextValue(next);
            }
            if (prev != null) {
                browseInfo.setPrevValue(prev);
            }
            browseInfo.setBrowseIndex(this.browseIndex);
            browseInfo.setSortOption(this.scope.getSortOption());
            browseInfo.setAscending(this.scope.isAscending());
            browseInfo.setBrowseLevel(this.scope.getBrowseLevel());
            browseInfo.setFocus(rawFocusValue);
            browseInfo.setStartsWith(this.scope.hasStartsWith());
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
            }
            browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
            return browseInfo;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private String getJumpToValue() throws BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "get_focus_value", ""));
        if (this.scope.hasJumpToValue()) {
            log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + this.scope.getJumpToValue()));
            return this.scope.getJumpToValue();
        }
        if (this.scope.hasStartsWith()) {
            log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + this.scope.getStartsWith()));
            return this.scope.getStartsWith();
        }
        int id = this.scope.getJumpToItem();
        String tableName = this.browseIndex.getTableName();
        SortOption so = this.scope.getSortOption();
        String col = "sort_value";
        if (so.getNumber() > 0) {
            col = "sort_" + Integer.toString(so.getNumber());
        }
        String max = this.dao.doMaxQuery(col, tableName, id);
        log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + max));
        return max;
    }

    private String normalizeJumpToValue(String value) throws BrowseException {
        if (this.scope.hasJumpToValue()) {
            return BrowseOrder.makeSortString(this.scope.getJumpToValue(), this.scope.setJumpToValueLang(), this.scope.getBrowseIndex().getDataType());
        }
        if (this.scope.hasStartsWith()) {
            return BrowseOrder.makeSortString(this.scope.getStartsWith(), null, this.scope.getBrowseIndex().getDataType());
        }
        return value;
    }

    private int getTotalResults() throws SQLException, BrowseException {
        return this.getTotalResults(false);
    }

    private int getTotalResults(boolean distinct) throws SQLException, BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "get_total_results", "distinct=" + distinct));
        String tableName = this.browseIndex.getTableName(distinct, this.scope.inCommunity(), this.scope.inCollection());
        this.dao.setDistinct(distinct);
        String[] select = new String[]{"*"};
        this.dao.setCountValues(select);
        String focusField = this.dao.getJumpToField();
        String focusValue = this.dao.getJumpToValue();
        String orderField = this.dao.getOrderField();
        int limit = this.dao.getLimit();
        int offset = this.dao.getOffset();
        this.dao.setJumpToField(null);
        this.dao.setJumpToValue(null);
        this.dao.setOrderField(null);
        this.dao.setLimit(-1);
        this.dao.setOffset(-1);
        int count = this.dao.doCountQuery();
        this.dao.setJumpToField(focusField);
        this.dao.setJumpToValue(focusValue);
        this.dao.setOrderField(orderField);
        this.dao.setLimit(limit);
        this.dao.setOffset(offset);
        log.debug((Object)LogManager.getHeader(this.context, "get_total_results_return", "return=" + count));
        return count;
    }

    private int getPosition(boolean distinct) throws SQLException, BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "get_position", "distinct=" + distinct));
        if (this.dao.getJumpToValue() == null) {
            log.debug((Object)LogManager.getHeader(this.context, "get_position_return", "return=0"));
            return 0;
        }
        String tableName = this.browseIndex.getTableName(distinct, this.scope.inCommunity(), this.scope.inCollection());
        String[] select = new String[]{"*"};
        this.dao.setCountValues(select);
        boolean isAscending = this.dao.isAscending();
        boolean useEquals = this.dao.useEqualsComparator();
        String orderField = this.dao.getOrderField();
        int limit = this.dao.getLimit();
        int offset = this.dao.getOffset();
        this.dao.setAscending(!isAscending);
        this.dao.setEqualsComparator(false);
        this.dao.setOrderField(null);
        this.dao.setLimit(-1);
        this.dao.setOffset(-1);
        int count = this.dao.doCountQuery();
        this.dao.setAscending(isAscending);
        this.dao.setEqualsComparator(useEquals);
        this.dao.setOrderField(orderField);
        this.dao.setLimit(limit);
        this.dao.setOffset(offset);
        log.debug((Object)LogManager.getHeader(this.context, "get_position_return", "return=" + count));
        return count;
    }

    private int getPreviousPageID(List callback) throws SQLException, BrowseException {
        boolean isAscending;
        log.debug((Object)LogManager.getHeader(this.context, "get_previous_page_id", ""));
        boolean capture = false;
        if (callback != null) {
            capture = true;
        }
        this.dao.setAscending(!(isAscending = this.dao.isAscending()));
        boolean useEquals = this.dao.useEqualsComparator();
        this.dao.setEqualsComparator(false);
        int resultLimit = this.dao.getLimit();
        int limit = this.scope.getResultsPerPage();
        if (capture) {
            limit *= 2;
        }
        this.dao.setLimit(limit);
        List results = this.dao.doQuery();
        this.dao.setAscending(isAscending);
        this.dao.setEqualsComparator(useEquals);
        this.dao.setLimit(resultLimit);
        Iterator itr = results.iterator();
        int i = 0;
        BrowseItem prev = null;
        while (itr.hasNext()) {
            BrowseItem browseItem;
            prev = browseItem = (BrowseItem)itr.next();
            if (!capture || i >= this.scope.getResultsPerPage()) continue;
            callback.add(0, browseItem);
            ++i;
        }
        if (prev != null) {
            return prev.getID();
        }
        return -1;
    }

    private String getPreviousPageValue(List callback) throws SQLException, BrowseException {
        boolean capture = false;
        if (callback != null) {
            capture = true;
        }
        log.debug((Object)LogManager.getHeader(this.context, "get_previous_page_value", "capture_results=" + capture));
        boolean isAscending = this.dao.isAscending();
        this.dao.setAscending(!isAscending);
        boolean useEquals = this.dao.useEqualsComparator();
        this.dao.setEqualsComparator(false);
        int resultLimit = this.dao.getLimit();
        int limit = this.scope.getResultsPerPage();
        if (capture) {
            limit *= 2;
        }
        this.dao.setLimit(limit);
        List results = this.dao.doValueQuery();
        this.dao.setAscending(isAscending);
        this.dao.setEqualsComparator(useEquals);
        this.dao.setLimit(resultLimit);
        Iterator itr = results.iterator();
        int i = 0;
        String prev = null;
        while (itr.hasNext()) {
            String value;
            prev = value = (String)itr.next();
            if (!capture || i >= this.scope.getResultsPerPage()) continue;
            callback.add(0, value);
            ++i;
        }
        log.debug((Object)LogManager.getHeader(this.context, "get_previous_page_value_return", "return=" + prev));
        return prev;
    }
}

