/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseOrderAuthor;
import org.dspace.browse.BrowseOrderDelegate;
import org.dspace.browse.BrowseOrderText;
import org.dspace.browse.BrowseOrderTitle;
import org.dspace.core.PluginManager;

public class BrowseOrder {
    private static final Logger log = LogManager.getLogger(BrowseOrder.class);
    public static final String AUTHOR = "author";
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    private static final String[] delegates = PluginManager.getAllPluginNames(BrowseOrderDelegate.class);
    private static final BrowseOrderDelegate authorDelegate = new BrowseOrderAuthor();
    private static final BrowseOrderDelegate titleDelegate = new BrowseOrderTitle();
    private static final BrowseOrderDelegate textDelegate = new BrowseOrderText();

    public static String makeSortString(String value, String language, String type) {
        BrowseOrderDelegate delegate = null;
        if (type != null && type.length() > 0 && (delegate = BrowseOrder.getDelegate(type)) != null) {
            return delegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(AUTHOR) && authorDelegate != null) {
            return authorDelegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(TITLE) && titleDelegate != null) {
            return titleDelegate.makeSortString(value, language);
        }
        if (type.equalsIgnoreCase(TEXT) && textDelegate != null) {
            return textDelegate.makeSortString(value, language);
        }
        return value;
    }

    private static BrowseOrderDelegate getDelegate(String name) {
        if (name != null && name.length() > 0) {
            for (int idx = 0; idx < delegates.length; ++idx) {
                if (!delegates[idx].equals(name)) continue;
                return (BrowseOrderDelegate)PluginManager.getNamedPlugin(BrowseOrderDelegate.class, name);
            }
        }
        return null;
    }
}

