/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Community
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Community.class);
    private Context ourContext;
    private TableRow communityRow;
    private Bitstream logo;
    private String handle;
    private boolean modified;
    private boolean modifiedMetadata;

    Community(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.communityRow = row;
        this.logo = this.communityRow.isColumnNull("logo_bitstream_id") ? null : Bitstream.find(this.ourContext, this.communityRow.getIntColumn("logo_bitstream_id"));
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("community_id"));
        this.modifiedMetadata = false;
        this.modified = false;
        this.clearDetails();
    }

    public static Community find(Context context, int id) throws SQLException {
        Community fromCache = (Community)context.fromCache(Community.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "community", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_community", "not_found,community_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_community", "community_id=" + id));
        }
        return new Community(context, row);
    }

    public static Community create(Community parent, Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context) && !AuthorizeManager.authorizeActionBoolean(context, parent, 3)) {
            throw new AuthorizeException("Only administrators can create communities");
        }
        TableRow row = DatabaseManager.create(context, "community");
        Community c = new Community(context, row);
        c.handle = HandleManager.createHandle(context, c);
        Group anonymousGroup = Group.find(context, 0);
        ResourcePolicy myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(0);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        context.addEvent(new Event(1, 4, c.getID(), c.handle));
        if (parent == null) {
            context.addEvent(new Event(8, 5, 0, 4, c.getID(), c.handle));
        }
        log.info((Object)(LogManager.getHeader(context, "create_community", "community_id=" + row.getIntColumn("community_id")) + ",handle=" + c.handle));
        return c;
    }

    public static Community[] findAll(Context context) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "community", "SELECT * FROM community ORDER BY name", new Object[0]);
        ArrayList<Community> communities = new ArrayList<Community>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Community fromCache = (Community)context.fromCache(Community.class, row.getIntColumn("community_id"));
            if (fromCache != null) {
                communities.add(fromCache);
                continue;
            }
            communities.add(new Community(context, row));
        }
        tri.close();
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    public static Community[] findAllTop(Context context) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "community", "SELECT * FROM community WHERE NOT community_id IN (SELECT child_comm_id FROM community2community) ORDER BY name", new Object[0]);
        ArrayList<Community> topCommunities = new ArrayList<Community>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Community fromCache = (Community)context.fromCache(Community.class, row.getIntColumn("community_id"));
            if (fromCache != null) {
                topCommunities.add(fromCache);
                continue;
            }
            topCommunities.add(new Community(context, row));
        }
        tri.close();
        Community[] communityArray = new Community[topCommunities.size()];
        communityArray = topCommunities.toArray(communityArray);
        return communityArray;
    }

    public int getID() {
        return this.communityRow.getIntColumn("community_id");
    }

    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public String getMetadata(String field) {
        String metadata = this.communityRow.getStringColumn(field);
        return metadata == null ? "" : metadata;
    }

    public void setMetadata(String field, String value) throws MissingResourceException {
        if (field.trim().equals("name") && value.trim().equals("")) {
            try {
                value = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        this.communityRow.setColumn(field, value);
        this.modifiedMetadata = true;
        this.addDetails(field);
    }

    public String getName() {
        return this.getMetadata("name");
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Bitstream setLogo(InputStream is) throws AuthorizeException, IOException, SQLException {
        if (is != null || !AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 2)) {
            this.canEdit();
        }
        if (this.logo != null) {
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_logo", "community_id=" + this.getID()));
            this.communityRow.setColumnNull("logo_bitstream_id");
            this.logo.delete();
            this.logo = null;
        }
        if (is != null) {
            Bitstream newLogo = Bitstream.create(this.ourContext, is);
            this.communityRow.setColumn("logo_bitstream_id", newLogo.getID());
            this.logo = newLogo;
            List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, this, 0);
            AuthorizeManager.addPolicies(this.ourContext, policies, newLogo);
            log.info((Object)LogManager.getHeader(this.ourContext, "set_logo", "community_id=" + this.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        this.modified = true;
        return this.logo;
    }

    public void update() throws SQLException, IOException, AuthorizeException {
        this.canEdit();
        log.info((Object)LogManager.getHeader(this.ourContext, "update_community", "community_id=" + this.getID()));
        DatabaseManager.update(this.ourContext, this.communityRow);
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 4, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, 4, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
    }

    public Collection[] getCollections() throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "collection", "SELECT collection.* FROM collection, community2collection WHERE community2collection.collection_id=collection.collection_id AND community2collection.community_id= ? ORDER BY collection.name", this.getID());
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Collection fromCache = (Collection)this.ourContext.fromCache(Collection.class, row.getIntColumn("collection_id"));
            if (fromCache != null) {
                collections.add(fromCache);
                continue;
            }
            collections.add(new Collection(this.ourContext, row));
        }
        tri.close();
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    public Community[] getSubcommunities() throws SQLException {
        ArrayList<Community> subcommunities = new ArrayList<Community>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2community WHERE community2community.child_comm_id=community.community_id AND community2community.parent_comm_id= ? ORDER BY community.name", this.getID());
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Community fromCache = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
            if (fromCache != null) {
                subcommunities.add(fromCache);
                continue;
            }
            subcommunities.add(new Community(this.ourContext, row));
        }
        tri.close();
        Community[] communityArray = new Community[subcommunities.size()];
        communityArray = subcommunities.toArray(communityArray);
        return communityArray;
    }

    public Community getParentCommunity() throws SQLException {
        Community parentCommunity = null;
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2community WHERE community2community.parent_comm_id=community.community_id AND community2community.child_comm_id= ? ", this.getID());
        if (tri.hasNext()) {
            TableRow row = tri.next();
            Community fromCache = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
            parentCommunity = fromCache != null ? fromCache : new Community(this.ourContext, row);
        }
        tri.close();
        return parentCommunity;
    }

    public Community[] getAllParents() throws SQLException {
        ArrayList<Community> parentList = new ArrayList<Community>();
        for (Community parent = this.getParentCommunity(); parent != null; parent = parent.getParentCommunity()) {
            parentList.add(parent);
        }
        Community[] communityArray = new Community[parentList.size()];
        communityArray = parentList.toArray(communityArray);
        return communityArray;
    }

    public Collection createCollection() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Collection c = Collection.create(this.ourContext);
        this.addCollection(c);
        return c;
    }

    public void addCollection(Collection c) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_collection", "community_id=" + this.getID() + ",collection_id=" + c.getID()));
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community2collection", "SELECT * FROM community2collection WHERE community_id= ? AND collection_id= ? ", this.getID(), c.getID());
        if (!tri.hasNext()) {
            TableRow mappingRow = DatabaseManager.create(this.ourContext, "community2collection");
            mappingRow.setColumn("community_id", this.getID());
            mappingRow.setColumn("collection_id", c.getID());
            this.ourContext.addEvent(new Event(8, 4, this.getID(), 3, c.getID(), c.getHandle()));
            DatabaseManager.update(this.ourContext, mappingRow);
        }
        tri.close();
    }

    public Community createSubcommunity() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Community c = Community.create(this, this.ourContext);
        this.addSubcommunity(c);
        return c;
    }

    public void addSubcommunity(Community c) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_subcommunity", "parent_comm_id=" + this.getID() + ",child_comm_id=" + c.getID()));
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community2community", "SELECT * FROM community2community WHERE parent_comm_id= ? AND child_comm_id= ? ", this.getID(), c.getID());
        if (!tri.hasNext()) {
            TableRow mappingRow = DatabaseManager.create(this.ourContext, "community2community");
            mappingRow.setColumn("parent_comm_id", this.getID());
            mappingRow.setColumn("child_comm_id", c.getID());
            this.ourContext.addEvent(new Event(8, 4, this.getID(), 4, c.getID(), c.getHandle()));
            DatabaseManager.update(this.ourContext, mappingRow);
        }
        tri.close();
    }

    public void removeCollection(Collection c) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_collection", "community_id=" + this.getID() + ",collection_id=" + c.getID()));
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM community2collection WHERE community_id= ? AND collection_id= ? ", this.getID(), c.getID());
        this.ourContext.addEvent(new Event(16, 4, this.getID(), 3, c.getID(), c.getHandle()));
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM community2collection WHERE collection_id= ? ", c.getID());
        if (!tri.hasNext()) {
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)c, 2, this.ourContext.getCurrentUser());
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)c, 4, this.ourContext.getCurrentUser());
            c.delete();
        }
        tri.close();
    }

    public void removeSubcommunity(Community c) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_subcommunity", "parent_comm_id=" + this.getID() + ",child_comm_id=" + c.getID()));
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM community2community WHERE parent_comm_id= ?  AND child_comm_id= ? ", this.getID(), c.getID());
        this.ourContext.addEvent(new Event(16, 4, this.getID(), 4, c.getID(), c.getHandle()));
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM community2community WHERE child_comm_id= ? ", c.getID());
        if (!tri.hasNext()) {
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)c, 2, this.ourContext.getCurrentUser());
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)c, 4, this.ourContext.getCurrentUser());
            c.delete();
        }
        tri.close();
    }

    public void delete() throws SQLException, AuthorizeException, IOException {
        Community parent;
        if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, this.getParentCommunity(), 4)) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 2);
        }
        if ((parent = this.getParentCommunity()) != null) {
            parent.removeSubcommunity(this);
            return;
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_community", "community_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 4, this.getID(), this.getHandle()));
        this.ourContext.removeCached(this, this.getID());
        Collection[] cols = this.getCollections();
        for (int i = 0; i < cols.length; ++i) {
            this.removeCollection(cols[i]);
        }
        Community[] comms = this.getSubcommunities();
        for (int j = 0; j < comms.length; ++j) {
            this.removeSubcommunity(comms[j]);
        }
        this.setLogo(null);
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.communityRow);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Community)) {
            return false;
        }
        return this.getID() == ((Community)other).getID();
    }

    public int getType() {
        return 4;
    }

    public boolean canEditBoolean() throws SQLException {
        try {
            this.canEdit();
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    public void canEdit() throws AuthorizeException, SQLException {
        Community[] parents = this.getAllParents();
        for (int i = 0; i < parents.length; ++i) {
            if (AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 1)) {
                return;
            }
            if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 3)) continue;
            return;
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
    }

    public int countItems() throws SQLException {
        int total = 0;
        Collection[] cols = this.getCollections();
        for (int i = 0; i < cols.length; ++i) {
            total += cols[i].countItems();
        }
        Community[] comms = this.getSubcommunities();
        for (int j = 0; j < comms.length; ++j) {
            total += comms[j].countItems();
        }
        return total;
    }
}

