/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.Utils;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;

public class PDFPackager
extends SelfNamedPlugin
implements PackageIngester,
PackageDisseminator {
    private static Logger log = Logger.getLogger(PDFPackager.class);
    private static final String BITSTREAM_FORMAT_NAME = "Adobe PDF";
    private static String[] aliases = new String[]{"PDF", "Adobe PDF", "pdf", "application/pdf"};

    public static String[] getPluginNames() {
        return aliases;
    }

    private static void setFormatToMIMEType(Context context, Bitstream bs, String mimeType) throws SQLException {
        BitstreamFormat[] bf = BitstreamFormat.findNonInternal(context);
        for (int i = 0; i < bf.length; ++i) {
            if (!bf[i].getMIMEType().equalsIgnoreCase(mimeType)) continue;
            bs.setFormat(bf[i]);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceItem ingest(Context context, Collection collection, InputStream pkg, PackageParameters params, String license) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        WorkspaceItem workspaceItem;
        InputStream bis = null;
        Object cos = null;
        boolean success = false;
        Bundle original = null;
        Bitstream bs = null;
        WorkspaceItem wi = null;
        try {
            wi = WorkspaceItem.create(context, collection, false);
            Item myitem = wi.getItem();
            original = myitem.createBundle("ORIGINAL");
            bs = original.createBitstream(pkg);
            pkg.close();
            bs.setName("package.pdf");
            PDFPackager.setFormatToMIMEType(context, bs, "application/pdf");
            bs.update();
            log.debug((Object)("Created bitstream ID=" + String.valueOf(bs.getID()) + ", parsing..."));
            this.crosswalkPDF(context, myitem, bs.retrieve());
            wi.update();
            context.commit();
            success = true;
            log.info((Object)LogManager.getHeader(context, "ingest", "Created new Item, db ID=" + String.valueOf(myitem.getID()) + ", WorkspaceItem ID=" + String.valueOf(wi.getID())));
            workspaceItem = wi;
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
                if (cos != null) {
                    cos.close();
                }
            }
            catch (IOException ie) {
                // empty catch block
            }
            if (!success) {
                if (original != null && bs != null) {
                    original.removeBitstream(bs);
                }
                if (wi != null) {
                    wi.deleteAll();
                }
            }
            context.commit();
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            }
            if (cos != null) {
                cos.close();
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        if (!success) {
            if (original != null && bs != null) {
                original.removeBitstream(bs);
            }
            if (wi != null) {
                wi.deleteAll();
            }
        }
        context.commit();
        return workspaceItem;
    }

    public Item replace(Context ctx, Item item, InputStream pckage, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("The replace operation is not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, OutputStream out) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (dso.getType() != 2) {
            throw new PackageValidationException("This disseminator can only handle objects of type ITEM.");
        }
        Item item = (Item)dso;
        BitstreamFormat pdff = BitstreamFormat.findByShortDescription(context, BITSTREAM_FORMAT_NAME);
        if (pdff == null) {
            throw new PackageValidationException("Cannot find BitstreamFormat \"Adobe PDF\"");
        }
        Bitstream pkgBs = PackageUtils.getBitstreamByFormat(item, pdff, "ORIGINAL");
        if (pkgBs == null) {
            throw new PackageValidationException("Cannot find Bitstream with format \"Adobe PDF\"");
        }
        Utils.copy(pkgBs.retrieve(), out);
    }

    public String getMIMEType(PackageParameters params) {
        return "application/pdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crosswalkPDF(Context context, Item item, InputStream metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        COSDocument cos = null;
        try {
            Calendar calValue;
            PDFParser parser = new PDFParser(metadata);
            parser.parse();
            cos = parser.getDocument();
            if (cos.getEncryptionDictionary() != null) {
                throw new MetadataValidationException("This packager cannot accept an encrypted PDF document.");
            }
            PDDocument pd = new PDDocument(cos);
            PDDocumentInformation docinfo = pd.getDocumentInformation();
            String title = docinfo.getTitle();
            if (title == null) {
                throw new MetadataValidationException("This PDF file is unacceptable, it does not have a value for \"Title\" in its Info dictionary.");
            }
            log.debug((Object)("PDF Info dict title=\"" + title + "\""));
            item.addDC("title", null, "en", title);
            String value = docinfo.getAuthor();
            if (value != null) {
                item.addDC("contributor", "author", null, value);
                log.debug((Object)("PDF Info dict author=\"" + value + "\""));
            }
            if ((value = docinfo.getCreator()) != null) {
                item.addDC("description", "provenance", "en", "Application that created the original document: " + value);
            }
            if ((value = docinfo.getProducer()) != null) {
                item.addDC("description", "provenance", "en", "Original document converted to PDF by: " + value);
            }
            if ((value = docinfo.getSubject()) != null) {
                item.addDC("description", "abstract", null, value);
            }
            if ((value = docinfo.getKeywords()) != null) {
                item.addDC("subject", "other", null, value);
            }
            if ((calValue = docinfo.getCreationDate()) == null) {
                calValue = docinfo.getModificationDate();
            }
            if (calValue != null) {
                item.addDC("date", "created", null, new DCDate(calValue.getTime()).toString());
            }
            item.update();
        }
        finally {
            if (cos != null) {
                cos.close();
            }
        }
    }
}

