/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;

public class PackageUtils {
    public static void checkMetadata(Item item) throws PackageValidationException {
        DCValue[] t = item.getDC("title", null, "*");
        if (t == null || t.length == 0) {
            throw new PackageValidationException("Item cannot be created without the required \"title\" DC metadata.");
        }
    }

    public static void addDepositLicense(Context context, String license, Item item, Collection collection) throws SQLException, IOException, AuthorizeException {
        if (license == null) {
            license = collection.getLicense();
        }
        ByteArrayInputStream lis = new ByteArrayInputStream(license.getBytes());
        Bundle lb = item.createBundle("LICENSE");
        Bitstream lbs = lb.createBitstream(lis);
        ((InputStream)lis).close();
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        if (bf == null) {
            bf = FormatIdentifier.guessFormat(context, lbs);
        }
        lbs.setFormat(bf);
        lbs.setName("license.txt");
        lbs.setSource("license.txt");
        lbs.update();
    }

    public static Bitstream getBitstreamByName(Item item, String name) throws SQLException {
        return PackageUtils.getBitstreamByName(item, name, null);
    }

    public static Bitstream getBitstreamByName(Item item, String bsName, String bnName) throws SQLException {
        Bundle[] bundles = bnName == null ? item.getBundles() : item.getBundles(bnName);
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                if (!bsName.equals(bitstreams[k].getName())) continue;
                return bitstreams[k];
            }
        }
        return null;
    }

    public static Bitstream getBitstreamByFormat(Item item, BitstreamFormat bsf, String bnName) throws SQLException {
        int fid = bsf.getID();
        Bundle[] bundles = bnName == null ? item.getBundles() : item.getBundles(bnName);
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                if (bitstreams[k].getFormat().getID() != fid) continue;
                return bitstreams[k];
            }
        }
        return null;
    }

    public static boolean isMetaInfoBundle(Bundle bn) {
        return bn.getName().equals("LICENSE") || bn.getName().equals("CC-LICENSE") || bn.getName().equals("METADATA");
    }

    public static BitstreamFormat findOrCreateBitstreamFormat(Context context, String shortDesc, String MIMEType, String desc) throws SQLException, AuthorizeException {
        BitstreamFormat bsf = BitstreamFormat.findByShortDescription(context, shortDesc);
        if (bsf == null) {
            bsf = BitstreamFormat.create(context);
            bsf.setShortDescription(shortDesc);
            bsf.setMIMEType(MIMEType);
            bsf.setDescription(desc);
            bsf.setSupportLevel(1);
            bsf.update();
        }
        return bsf;
    }

    public static class UnclosableInputStream
    extends FilterInputStream {
        public UnclosableInputStream(InputStream in) {
            super(in);
        }

        public void close() {
        }
    }
}

