/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.oro.text.perl.Perl5Util;

public class QueryArgs {
    private String query;
    private int start = 0;
    private int pageSize = 10;

    public void setQuery(String newQuery) {
        this.query = newQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setStart(int newStart) {
        this.start = newStart;
    }

    public int getStart() {
        return this.start;
    }

    public void setPageSize(int newSize) {
        this.pageSize = newSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String buildQuery(HttpServletRequest request) {
        String newquery = "(";
        String numFieldStr = request.getParameter("num_search_field");
        if (numFieldStr == null) {
            numFieldStr = "3";
        }
        int numField = Integer.parseInt(numFieldStr);
        ArrayList<String> query = new ArrayList<String>();
        ArrayList<String> field = new ArrayList<String>();
        ArrayList<String> conjunction = new ArrayList<String>();
        for (int i = 1; i <= numField; ++i) {
            String tmp_query = request.getParameter("query" + i);
            String tmp_field = request.getParameter("field" + i);
            if (tmp_field != null) {
                tmp_field = tmp_field.replace('/', ' ');
                tmp_field = tmp_field.replace('<', ' ');
                tmp_field = tmp_field.replace('\\', ' ');
                tmp_field = tmp_field.replace(':', ' ');
            }
            if (tmp_query == null || tmp_query.equals("")) continue;
            query.add(tmp_query.trim());
            if (tmp_field == null) {
                field.add("ANY");
            } else {
                field.add(tmp_field.trim());
            }
            if (i == numField) continue;
            conjunction.add(request.getParameter("conjunction" + i) != null ? request.getParameter("conjunction" + i) : "AND");
        }
        Iterator iquery = query.iterator();
        Iterator ifield = field.iterator();
        Iterator iconj = conjunction.iterator();
        String conj_curr = "";
        while (iquery.hasNext()) {
            newquery = newquery + conj_curr;
            String query_curr = (String)iquery.next();
            String field_curr = (String)ifield.next();
            newquery = newquery + this.buildQueryPart(query_curr, field_curr);
            if (!iconj.hasNext()) continue;
            conj_curr = " " + (String)iconj.next() + " ";
        }
        newquery = newquery + ")";
        return newquery;
    }

    private String buildQueryPart(String myquery, String myfield) {
        Perl5Util util = new Perl5Util();
        String newquery = "(";
        if (!myfield.equals("ANY")) {
            newquery = newquery + myfield + ":";
            if (!util.match("/\".*\"/", myquery = util.substitute("s/'(.*)'/\"$1\"/g", myquery))) {
                myquery = util.substitute("s/ / " + myfield + ":/g", myquery);
            }
        }
        newquery = newquery + myquery + ")";
        return newquery;
    }

    public HashMap buildQueryHash(HttpServletRequest request) {
        HashMap<String, String> queryHash = new HashMap<String, String>();
        String numFieldStr = request.getParameter("num_search_field");
        if (numFieldStr == null) {
            numFieldStr = "3";
        }
        int numField = Integer.parseInt(numFieldStr);
        for (int i = 1; i < numField; ++i) {
            queryHash.put("query" + i, request.getParameter("query" + i) == null ? "" : request.getParameter("query" + i));
            queryHash.put("field" + i, request.getParameter("field" + i) == null ? "ANY" : request.getParameter("field" + i));
            queryHash.put("conjunction" + i, request.getParameter("conjunction" + i) == null ? "AND" : request.getParameter("conjunction" + i));
        }
        queryHash.put("query" + numField, request.getParameter("query" + numField) == null ? "" : request.getParameter("query" + numField));
        queryHash.put("field" + numField, request.getParameter("field" + numField) == null ? "ANY" : request.getParameter("field" + numField));
        return queryHash;
    }

    public String buildHTTPQuery(HttpServletRequest request) throws UnsupportedEncodingException {
        String querystring = "";
        HashMap queryHash = this.buildQueryHash(request);
        for (String key : queryHash.keySet()) {
            String value = (String)queryHash.get(key);
            querystring = querystring + "&" + key + "=" + URLEncoder.encode(value, "UTF-8");
        }
        if (request.getParameter("num_search_field") != null) {
            querystring = querystring + "&num_search_field=" + request.getParameter("num_search_field");
        }
        return querystring.substring(1);
    }
}

