/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dspace.core.ConfigurationManager;

public class TableRow {
    private static final Object NULL_OBJECT = new Object();
    private String table;
    private Map data = new HashMap();

    public TableRow(String table, List columns) {
        this.table = table;
        this.nullColumns(columns);
    }

    public String getTable() {
        return this.table;
    }

    public boolean hasColumn(String column) {
        return this.data.get(TableRow.canonicalize(column)) != null;
    }

    public boolean isColumnNull(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        return this.data.get(TableRow.canonicalize(column)) == NULL_OBJECT;
    }

    public int getIntColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return -1;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value for " + column + " is not an integer");
        }
        return (Integer)value;
    }

    public long getLongColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return -1L;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("Value for " + column + " is not a long");
        }
        return (Long)value;
    }

    public String getStringColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return null;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Value is not an string");
        }
        return (String)value;
    }

    public boolean getBooleanColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return false;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            return i != 0;
        }
        throw new IllegalArgumentException("Value is not a boolean or an integer");
    }

    public Date getDateColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return null;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value is not a Date");
        }
        return (Date)value;
    }

    public void setColumnNull(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        this.setColumnNullInternal(TableRow.canonicalize(column));
    }

    public void setColumn(String column, boolean b) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            this.data.put(TableRow.canonicalize(column), b ? new Integer(1) : new Integer(0));
        } else {
            this.data.put(TableRow.canonicalize(column), b ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setColumn(String column, String s) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        this.data.put(TableRow.canonicalize(column), s == null ? NULL_OBJECT : s);
    }

    public void setColumn(String column, int i) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        this.data.put(TableRow.canonicalize(column), new Integer(i));
    }

    public void setColumn(String column, long l) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        this.data.put(TableRow.canonicalize(column), new Long(l));
    }

    public void setColumn(String column, Date d) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        if (d == null) {
            this.setColumnNull(TableRow.canonicalize(column));
            return;
        }
        this.data.put(TableRow.canonicalize(column), d);
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer result = this.table == null ? new StringBuffer("no_table") : new StringBuffer(this.table);
        result.append(NEWLINE);
        for (String column : this.data.keySet()) {
            result.append("\t").append(column).append(" = ").append((Object)(this.isColumnNull(column) ? "NULL" : this.data.get(column))).append(NEWLINE);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableRow)) {
            return false;
        }
        return ((Object)this.data).equals(((TableRow)obj).data);
    }

    static String canonicalize(String column) {
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            return column.toUpperCase();
        }
        return column.toLowerCase();
    }

    private void nullColumns(List columns) {
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.setColumnNullInternal((String)iterator.next());
        }
    }

    private void setColumnNullInternal(String column) {
        this.data.put(TableRow.canonicalize(column), NULL_OBJECT);
    }
}

