/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowItem;

public class Collection
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Collection.class);
    private Context ourContext;
    private TableRow collectionRow;
    private Bitstream logo;
    private Item template;
    private String handle;
    private boolean modified;
    private boolean modifiedMetadata;
    private Group[] workflowGroup;
    private Group submitters;
    private Group admins;

    Collection(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.collectionRow = row;
        this.logo = this.collectionRow.isColumnNull("logo_bitstream_id") ? null : Bitstream.find(this.ourContext, this.collectionRow.getIntColumn("logo_bitstream_id"));
        this.template = this.collectionRow.isColumnNull("template_item_id") ? null : Item.find(this.ourContext, this.collectionRow.getIntColumn("template_item_id"));
        this.workflowGroup = new Group[3];
        this.workflowGroup[0] = this.groupFromColumn("workflow_step_1");
        this.workflowGroup[1] = this.groupFromColumn("workflow_step_2");
        this.workflowGroup[2] = this.groupFromColumn("workflow_step_3");
        this.submitters = this.groupFromColumn("submitter");
        this.admins = this.groupFromColumn("admin");
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("collection_id"));
        this.modifiedMetadata = false;
        this.modified = false;
        this.clearDetails();
    }

    public static Collection find(Context context, int id) throws SQLException {
        Collection fromCache = (Collection)context.fromCache(Collection.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "collection", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_collection", "not_found,collection_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_collection", "collection_id=" + id));
        }
        return new Collection(context, row);
    }

    static Collection create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "collection");
        Collection c = new Collection(context, row);
        c.handle = HandleManager.createHandle(context, c);
        Group anonymousGroup = Group.find(context, 0);
        ResourcePolicy myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(0);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(10);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(9);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        context.addEvent(new Event(1, 3, c.getID(), c.handle));
        log.info((Object)(LogManager.getHeader(context, "create_collection", "collection_id=" + row.getIntColumn("collection_id")) + ",handle=" + c.handle));
        return c;
    }

    public static Collection[] findAll(Context context) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "collection", "SELECT * FROM collection ORDER BY name", new Object[0]);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Collection fromCache = (Collection)context.fromCache(Collection.class, row.getIntColumn("collection_id"));
            if (fromCache != null) {
                collections.add(fromCache);
                continue;
            }
            collections.add(new Collection(context, row));
        }
        tri.close();
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    public ItemIterator getItems() throws SQLException {
        String myQuery = "SELECT item.* FROM item, collection2item WHERE item.item_id=collection2item.item_id AND collection2item.collection_id= ? AND item.in_archive='1'";
        TableRowIterator rows = DatabaseManager.queryTable(this.ourContext, "item", myQuery, this.getID());
        return new ItemIterator(this.ourContext, rows);
    }

    public ItemIterator getAllItems() throws SQLException {
        String myQuery = "SELECT item.* FROM item, collection2item WHERE item.item_id=collection2item.item_id AND collection2item.collection_id= ? ";
        TableRowIterator rows = DatabaseManager.queryTable(this.ourContext, "item", myQuery, this.getID());
        return new ItemIterator(this.ourContext, rows);
    }

    public int getID() {
        return this.collectionRow.getIntColumn("collection_id");
    }

    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public String getMetadata(String field) {
        String metadata = this.collectionRow.getStringColumn(field);
        return metadata == null ? "" : metadata;
    }

    public void setMetadata(String field, String value) throws MissingResourceException {
        if (field.trim().equals("name") && value.trim().equals("")) {
            try {
                value = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        this.collectionRow.setColumn(field, value);
        this.modifiedMetadata = true;
        this.addDetails(field);
    }

    public String getName() {
        return this.getMetadata("name");
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Bitstream setLogo(InputStream is) throws AuthorizeException, IOException, SQLException {
        if (is != null || !AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 2)) {
            this.canEdit();
        }
        if (!this.collectionRow.isColumnNull("logo_bitstream_id")) {
            this.logo.delete();
        }
        if (is == null) {
            this.collectionRow.setColumnNull("logo_bitstream_id");
            this.logo = null;
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_logo", "collection_id=" + this.getID()));
        } else {
            Bitstream newLogo = Bitstream.create(this.ourContext, is);
            this.collectionRow.setColumn("logo_bitstream_id", newLogo.getID());
            this.logo = newLogo;
            List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, this, 0);
            AuthorizeManager.addPolicies(this.ourContext, policies, newLogo);
            log.info((Object)LogManager.getHeader(this.ourContext, "set_logo", "collection_id=" + this.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        this.modified = true;
        return this.logo;
    }

    public Group createWorkflowGroup(int step) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        if (this.workflowGroup[step - 1] == null) {
            Group g = Group.create(this.ourContext);
            g.setName("COLLECTION_" + this.getID() + "_WORKFLOW_STEP_" + step);
            g.update();
            this.setWorkflowGroup(step, g);
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 3, g);
        }
        return this.workflowGroup[step - 1];
    }

    public void setWorkflowGroup(int step, Group g) {
        this.workflowGroup[step - 1] = g;
        if (g == null) {
            this.collectionRow.setColumnNull("workflow_step_" + step);
        } else {
            this.collectionRow.setColumn("workflow_step_" + step, g.getID());
        }
        this.modified = true;
    }

    public Group getWorkflowGroup(int step) {
        return this.workflowGroup[step - 1];
    }

    public Group createSubmitters() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        if (this.submitters == null) {
            this.submitters = Group.create(this.ourContext);
            this.submitters.setName("COLLECTION_" + this.getID() + "_SUBMIT");
            this.submitters.update();
        }
        this.collectionRow.setColumn("submitter", this.submitters.getID());
        AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 3, this.submitters);
        this.modified = true;
        return this.submitters;
    }

    public Group getSubmitters() {
        return this.submitters;
    }

    public Group createAdministrators() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        if (this.admins == null) {
            this.admins = Group.create(this.ourContext);
            this.admins.setName("COLLECTION_" + this.getID() + "_ADMIN");
            this.admins.update();
        }
        AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 11, this.admins);
        this.collectionRow.setColumn("admin", this.admins.getID());
        if (this.submitters != null) {
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this.submitters, 3, this.admins);
        }
        this.modified = true;
        return this.admins;
    }

    public Group getAdministrators() {
        return this.admins;
    }

    public String getLicense() {
        String license = this.collectionRow.getStringColumn("license");
        if (license == null || license.equals("")) {
            license = ConfigurationManager.getDefaultSubmissionLicense();
        }
        return license;
    }

    public String getLicenseCollection() {
        String license = this.collectionRow.getStringColumn("license");
        return license;
    }

    public boolean hasCustomLicense() {
        String license = this.collectionRow.getStringColumn("license");
        return license != null && !license.equals("");
    }

    public void setLicense(String license) {
        if (license == null) {
            this.collectionRow.setColumnNull("license");
        } else {
            this.collectionRow.setColumn("license", license);
        }
        this.modified = true;
    }

    public Item getTemplateItem() throws SQLException {
        return this.template;
    }

    public void createTemplateItem() throws SQLException, AuthorizeException {
        this.canEdit();
        if (this.template == null) {
            this.template = Item.create(this.ourContext);
            this.collectionRow.setColumn("template_item_id", this.template.getID());
            log.info((Object)LogManager.getHeader(this.ourContext, "create_template_item", "collection_id=" + this.getID() + ",template_item_id=" + this.template.getID()));
        }
        this.modified = true;
    }

    public void removeTemplateItem() throws SQLException, AuthorizeException, IOException {
        this.canEdit();
        this.collectionRow.setColumnNull("template_item_id");
        DatabaseManager.update(this.ourContext, this.collectionRow);
        if (this.template != null) {
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_template_item", "collection_id=" + this.getID() + ",template_item_id=" + this.template.getID()));
            this.template.delete();
            this.template = null;
        }
        this.ourContext.addEvent(new Event(2, 3, this.getID(), "remove_template_item"));
    }

    public void addItem(Item item) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_item", "collection_id=" + this.getID() + ",item_id=" + item.getID()));
        TableRow row = DatabaseManager.create(this.ourContext, "collection2item");
        row.setColumn("collection_id", this.getID());
        row.setColumn("item_id", item.getID());
        DatabaseManager.update(this.ourContext, row);
        this.ourContext.addEvent(new Event(8, 3, this.getID(), 2, item.getID(), item.getHandle()));
    }

    public void removeItem(Item item) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_item", "collection_id=" + this.getID() + ",item_id=" + item.getID()));
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM collection2item WHERE collection_id= ? AND item_id= ? ", this.getID(), item.getID());
        this.ourContext.addEvent(new Event(16, 3, this.getID(), 2, item.getID(), item.getHandle()));
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM collection2item WHERE item_id= ? ", item.getID());
        if (!tri.hasNext()) {
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)item, 2, this.ourContext.getCurrentUser());
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)item, 4, this.ourContext.getCurrentUser());
            item.delete();
        }
        tri.close();
    }

    public void update() throws SQLException, IOException, AuthorizeException {
        this.canEdit();
        log.info((Object)LogManager.getHeader(this.ourContext, "update_collection", "collection_id=" + this.getID()));
        DatabaseManager.update(this.ourContext, this.collectionRow);
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 3, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, 3, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
    }

    public boolean canEditBoolean() throws SQLException {
        try {
            this.canEdit();
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    public void canEdit() throws AuthorizeException, SQLException {
        Community[] parents = this.getCommunities();
        for (int i = 0; i < parents.length; ++i) {
            if (AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 1)) {
                return;
            }
            if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 3)) continue;
            return;
        }
        AuthorizeManager.authorizeAnyOf(this.ourContext, this, new int[]{1, 11});
    }

    /*
     * Unable to fully structure code
     */
    void delete() throws SQLException, AuthorizeException, IOException {
        Collection.log.info((Object)LogManager.getHeader(this.ourContext, "delete_collection", "collection_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 3, this.getID(), this.getHandle()));
        this.ourContext.removeCached(this, this.getID());
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM subscription WHERE collection_id= ? ", new Object[]{this.getID()});
        this.removeTemplateItem();
        items = this.getAllItems();
lbl8:
        // 2 sources

        try {
            while (items.hasNext()) {
                block13: {
                    item = items.next();
                    ib = new IndexBrowse(this.ourContext);
                    if (!item.isOwningCollection(this)) break block13;
                    collections = item.getCollections();
                    for (i = 0; i < collections.length; ++i) {
                        ib.itemRemoved(item);
                        collections[i].removeItem(item);
                    }
                    ** GOTO lbl8
                }
                ib.indexItem(item);
                this.removeItem(item);
            }
        }
        catch (BrowseException e) {
            Collection.log.error((Object)"caught exception: ", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        this.setLogo(null);
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        wfarray = WorkflowItem.findByCollection(this.ourContext, this);
        for (x = 0; x < wfarray.length; ++x) {
            myItem = wfarray[x].getItem();
            wfarray[x].deleteWrapper();
            myItem.delete();
        }
        wsarray = WorkspaceItem.findByCollection(this.ourContext, this);
        for (x = 0; x < wsarray.length; ++x) {
            wsarray[x].deleteAll();
        }
        try {
            ic = new ItemCounter(this.ourContext);
            ic.remove(this);
        }
        catch (ItemCountException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DatabaseManager.delete(this.ourContext, this.collectionRow);
        g = null;
        g = this.getWorkflowGroup(1);
        if (g != null) {
            g.delete();
        }
        if ((g = this.getWorkflowGroup(2)) != null) {
            g.delete();
        }
        if ((g = this.getWorkflowGroup(3)) != null) {
            g.delete();
        }
        if ((g = this.getAdministrators()) != null) {
            g.delete();
        }
        if ((g = this.getSubmitters()) != null) {
            g.delete();
        }
    }

    public Community[] getCommunities() throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2collection WHERE community.community_id=community2collection.community_id AND community2collection.collection_id= ? ", this.getID());
        ArrayList<Community> communities = new ArrayList<Community>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            Community owner = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
            if (owner == null) {
                owner = new Community(this.ourContext, row);
            }
            communities.add(owner);
            Community[] parents = owner.getAllParents();
            for (int i = 0; i < parents.length; ++i) {
                communities.add(parents[i]);
            }
        }
        tri.close();
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Collection)) {
            return false;
        }
        return this.getID() == ((Collection)other).getID();
    }

    private Group groupFromColumn(String col) throws SQLException {
        if (this.collectionRow.isColumnNull(col)) {
            return null;
        }
        return Group.find(this.ourContext, this.collectionRow.getIntColumn(col));
    }

    public int getType() {
        return 3;
    }

    public static Collection[] findAuthorized(Context context, Community comm, int actionID) throws SQLException {
        ArrayList<Collection> myResults = new ArrayList<Collection>();
        Collection[] myCollections = null;
        myCollections = comm != null ? comm.getCollections() : Collection.findAll(context);
        for (int i = 0; i < myCollections.length; ++i) {
            if (!AuthorizeManager.authorizeActionBoolean(context, myCollections[i], actionID)) continue;
            myResults.add(myCollections[i]);
        }
        myCollections = new Collection[myResults.size()];
        myCollections = myResults.toArray(myCollections);
        return myCollections;
    }

    public int countItems() throws SQLException {
        String query = "SELECT count(*) FROM collection2item, item WHERE collection2item.collection_id =  ? AND collection2item.item_id = item.item_id AND in_archive ='1' AND item.withdrawn='0' ";
        PreparedStatement statement = this.ourContext.getDBConnection().prepareStatement(query);
        statement.setInt(1, this.getID());
        ResultSet rs = statement.executeQuery();
        rs.next();
        int itemcount = rs.getInt(1);
        statement.close();
        return itemcount;
    }
}

