/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BrowseDAOPostgres
implements BrowseDAO {
    private static Logger log = Logger.getLogger(BrowseDAOPostgres.class);
    private Context context;
    private BrowseDAOUtils utils;
    private String[] selectValues = new String[]{"*"};
    private String[] countValues;
    private String table = null;
    private String tableDis = null;
    private String tableMap = null;
    private String focusField = null;
    private String focusValue = null;
    private String valueField = null;
    private String value = null;
    private boolean valuePartial = false;
    private String containerTable = null;
    private String containerIDField = null;
    private int containerID = -1;
    private String orderField = null;
    private boolean ascending = true;
    private int limit = -1;
    private int offset = 0;
    private boolean equalsComparator = true;
    private boolean distinct = false;
    private String querySql = "";
    private ArrayList queryParams = new ArrayList();
    private boolean rebuildQuery = true;
    private String whereClauseOperator = "";
    private boolean itemsInArchive = true;
    private boolean itemsWithdrawn = false;

    public BrowseDAOPostgres(Context context) throws BrowseException {
        this.context = context;
        this.utils = BrowseDAOFactory.getUtils(context);
    }

    public int doCountQuery() throws BrowseException {
        String query = this.getQuery();
        Object[] params = this.getQueryParams();
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(this.context, "executing_count_query", "query=" + query));
        }
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, query, params);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int n = (int)row.getLongColumn("num");
                return n;
            }
            int row = 0;
            return row;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public String doMaxQuery(String column, String table, int itemID) throws BrowseException {
        TableRowIterator tri = null;
        try {
            String query = "SELECT max(" + column + ") FROM " + table + " WHERE item_id = ?";
            Object[] params = new Object[]{new Integer(itemID)};
            tri = DatabaseManager.query(this.context, query, params);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                String string = row.getStringColumn("max");
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public int doOffsetQuery(String column, String value, boolean isAscending) throws BrowseException {
        TableRowIterator tri = null;
        try {
            ArrayList<String> paramsList = new ArrayList<String>();
            StringBuffer queryBuf = new StringBuffer();
            queryBuf.append("COUNT(").append(column).append(") AS offset ");
            this.buildSelectStatement(queryBuf, paramsList);
            if (isAscending) {
                queryBuf.append(" WHERE ").append(column).append("<?");
                paramsList.add(value);
            } else {
                queryBuf.append(" WHERE ").append(column).append(">?");
                paramsList.add(value + '\uffff');
            }
            if (this.containerTable != null || value != null && this.valueField != null && this.tableDis != null && this.tableMap != null) {
                queryBuf.append(" AND ").append("mappings.item_id=");
                queryBuf.append(this.table).append(".item_id");
            }
            if ((tri = DatabaseManager.query(this.context, queryBuf.toString(), paramsList.toArray())).hasNext()) {
                TableRow row = tri.next();
                int n = (int)row.getLongColumn("offset");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public int doDistinctOffsetQuery(String column, String value, boolean isAscending) throws BrowseException {
        TableRowIterator tri = null;
        try {
            ArrayList<String> paramsList = new ArrayList<String>();
            StringBuffer queryBuf = new StringBuffer();
            queryBuf.append("COUNT(").append(column).append(") AS offset ");
            this.buildSelectStatementDistinct(queryBuf, paramsList);
            if (isAscending) {
                queryBuf.append(" WHERE ").append(column).append("<?");
                paramsList.add(value);
            } else {
                queryBuf.append(" WHERE ").append(column).append(">?");
                paramsList.add(value + '\uffff');
            }
            if (this.containerTable != null && this.tableMap != null) {
                queryBuf.append(" AND ").append("mappings.distinct_id=");
                queryBuf.append(this.table).append(".id");
            }
            if ((tri = DatabaseManager.query(this.context, queryBuf.toString(), paramsList.toArray())).hasNext()) {
                TableRow row = tri.next();
                int n = (int)row.getLongColumn("offset");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public List doQuery() throws BrowseException {
        String query = this.getQuery();
        Object[] params = this.getQueryParams();
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(this.context, "executing_full_query", "query=" + query));
        }
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, query, params);
            ArrayList<BrowseItem> results = new ArrayList<BrowseItem>();
            while (tri.hasNext()) {
                TableRow row = tri.next();
                BrowseItem browseItem = new BrowseItem(this.context, row.getIntColumn("item_id"), this.itemsInArchive, this.itemsWithdrawn);
                results.add(browseItem);
            }
            ArrayList<BrowseItem> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException("problem with query: " + query, e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public List doValueQuery() throws BrowseException {
        String query = this.getQuery();
        Object[] params = this.getQueryParams();
        log.debug((Object)LogManager.getHeader(this.context, "executing_value_query", "query=" + query));
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, query, params);
            ArrayList<String> results = new ArrayList<String>();
            while (tri.hasNext()) {
                TableRow row = tri.next();
                String stringResult = row.getStringColumn("value");
                results.add(stringResult);
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public int getContainerID() {
        return this.containerID;
    }

    public String getContainerIDField() {
        return this.containerIDField;
    }

    public String getContainerTable() {
        return this.containerTable;
    }

    public String[] getCountValues() {
        return this.countValues;
    }

    public String getJumpToField() {
        return this.focusField;
    }

    public String getJumpToValue() {
        return this.focusValue;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public String[] getSelectValues() {
        return this.selectValues;
    }

    public String getTable() {
        return this.table;
    }

    public String getFilterValue() {
        return this.value;
    }

    public String getFilterValueField() {
        return this.valueField;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.rebuildQuery = true;
    }

    public void setContainerID(int containerID) {
        this.containerID = containerID;
        this.rebuildQuery = true;
    }

    public void setContainerIDField(String containerIDField) {
        this.containerIDField = containerIDField;
        this.rebuildQuery = true;
    }

    public void setContainerTable(String containerTable) {
        this.containerTable = containerTable;
        this.rebuildQuery = true;
    }

    public void setCountValues(String[] fields) {
        this.countValues = fields;
        this.rebuildQuery = true;
    }

    public void setDistinct(boolean bool) {
        this.distinct = bool;
        this.rebuildQuery = true;
    }

    public void setEqualsComparator(boolean equalsComparator) {
        this.equalsComparator = equalsComparator;
        this.rebuildQuery = true;
    }

    public void setJumpToField(String focusField) {
        this.focusField = focusField;
        this.rebuildQuery = true;
    }

    public void setJumpToValue(String focusValue) {
        this.focusValue = focusValue;
        this.rebuildQuery = true;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.rebuildQuery = true;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.rebuildQuery = true;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
        this.rebuildQuery = true;
    }

    public void setSelectValues(String[] selectValues) {
        this.selectValues = selectValues;
        this.rebuildQuery = true;
    }

    public void setTable(String table) {
        this.table = table;
        if (table.equals(BrowseIndex.getWithdrawnBrowseIndex().getTableName())) {
            this.itemsInArchive = false;
            this.itemsWithdrawn = true;
        } else {
            this.itemsInArchive = true;
            this.itemsWithdrawn = false;
        }
        this.rebuildQuery = true;
    }

    public void setFilterMappingTables(String tableDis, String tableMap) {
        this.tableDis = tableDis;
        this.tableMap = tableMap;
    }

    public void setFilterValue(String value) {
        this.value = value;
        this.rebuildQuery = true;
    }

    public void setFilterValuePartial(boolean part) {
        this.valuePartial = part;
        this.rebuildQuery = true;
    }

    public void setFilterValueField(String valueField) {
        this.valueField = valueField;
        this.rebuildQuery = true;
    }

    public boolean useEqualsComparator() {
        return this.equalsComparator;
    }

    private String buildDistinctQuery(List params) throws BrowseException {
        StringBuffer queryBuf = new StringBuffer();
        if (!this.buildSelectListCount(queryBuf) && !this.buildSelectListValues(queryBuf)) {
            throw new BrowseException("No arguments for SELECT statement");
        }
        this.buildSelectStatementDistinct(queryBuf, params);
        this.buildWhereClauseOpReset();
        this.buildWhereClauseJumpTo(queryBuf, params);
        this.buildWhereClauseDistinctConstraints(queryBuf, params);
        this.buildOrderBy(queryBuf);
        this.buildRowLimitAndOffset(queryBuf, params);
        return queryBuf.toString();
    }

    private String buildQuery(List params) throws BrowseException {
        StringBuffer queryBuf = new StringBuffer();
        if (!this.buildSelectListCount(queryBuf) && !this.buildSelectListValues(queryBuf)) {
            throw new BrowseException("No arguments for SELECT statement");
        }
        this.buildSelectStatement(queryBuf, params);
        this.buildWhereClauseOpReset();
        this.buildWhereClauseJumpTo(queryBuf, params);
        this.buildWhereClauseFilterValue(queryBuf, params);
        this.buildWhereClauseFullConstraints(queryBuf, params);
        this.buildOrderBy(queryBuf);
        this.buildRowLimitAndOffset(queryBuf, params);
        return queryBuf.toString();
    }

    private void buildOrderBy(StringBuffer queryBuf) {
        if (this.orderField != null) {
            queryBuf.append(" ORDER BY ");
            queryBuf.append(this.orderField);
            if (this.isAscending()) {
                queryBuf.append(" ASC ");
            } else {
                queryBuf.append(" DESC ");
            }
        }
    }

    private void buildRowLimitAndOffset(StringBuffer queryBuf, List params) {
        if (this.limit > 0) {
            queryBuf.append(" LIMIT ? ");
            params.add(new Integer(this.limit));
        }
        if (this.offset > 0) {
            queryBuf.append(" OFFSET ? ");
            params.add(new Integer(this.offset));
        }
    }

    private void buildFocusedSelectClauses(StringBuffer queryBuf, List params) {
        if (this.tableMap != null && this.tableDis != null) {
            queryBuf.append(this.tableMap).append(".distinct_id=").append(this.tableDis).append(".id");
            queryBuf.append(" AND ");
            queryBuf.append(this.tableDis).append(".sort_value");
            if (this.valuePartial) {
                queryBuf.append(" LIKE ? ");
                if (this.valueField.startsWith("sort_")) {
                    params.add("%" + this.utils.truncateSortValue(this.value) + "%");
                } else {
                    params.add("%" + this.utils.truncateValue(this.value) + "%");
                }
            } else {
                queryBuf.append("=? ");
                if (this.valueField.startsWith("sort_")) {
                    params.add(this.utils.truncateSortValue(this.value));
                } else {
                    params.add(this.utils.truncateValue(this.value));
                }
            }
        }
        if (this.containerTable != null && this.containerIDField != null && this.containerID != -1) {
            if (this.tableMap != null) {
                if (this.tableDis != null) {
                    queryBuf.append(" AND ");
                }
                queryBuf.append(this.tableMap).append(".item_id=").append(this.containerTable).append(".item_id AND ");
            }
            queryBuf.append(this.containerTable).append(".").append(this.containerIDField);
            queryBuf.append("=? ");
            params.add(new Integer(this.containerID));
        }
    }

    private void buildFocusedSelectTables(StringBuffer queryBuf) {
        if (this.containerTable != null) {
            queryBuf.append(this.containerTable);
        }
        if (this.tableMap != null) {
            if (this.containerTable != null) {
                queryBuf.append(", ");
            }
            queryBuf.append(this.tableMap);
            if (this.tableDis != null) {
                queryBuf.append(", ").append(this.tableDis);
            }
        }
    }

    private boolean buildSelectListCount(StringBuffer queryBuf) {
        if (this.countValues != null && this.countValues.length > 0) {
            queryBuf.append(" COUNT(");
            if ("*".equals(this.countValues[0])) {
                queryBuf.append(this.countValues[0]);
            } else {
                queryBuf.append(this.table).append(".").append(this.countValues[0]);
            }
            for (int i = 1; i < this.countValues.length; ++i) {
                queryBuf.append(", ");
                if ("*".equals(this.countValues[i])) {
                    queryBuf.append(this.countValues[i]);
                    continue;
                }
                queryBuf.append(this.table).append(".").append(this.countValues[i]);
            }
            queryBuf.append(") AS num");
            return true;
        }
        return false;
    }

    private boolean buildSelectListValues(StringBuffer queryBuf) {
        if (this.selectValues != null && this.selectValues.length > 0) {
            queryBuf.append(this.table).append(".").append(this.selectValues[0]);
            for (int i = 1; i < this.selectValues.length; ++i) {
                queryBuf.append(", ");
                queryBuf.append(this.table).append(".").append(this.selectValues[i]);
            }
            return true;
        }
        return false;
    }

    private void buildSelectStatement(StringBuffer queryBuf, List params) throws BrowseException {
        if (queryBuf.length() == 0) {
            throw new BrowseException("No arguments for SELECT statement");
        }
        if (this.table == null || "".equals(this.table)) {
            throw new BrowseException("No table for SELECT statement");
        }
        queryBuf.insert(0, "SELECT ");
        queryBuf.append(" FROM ");
        queryBuf.append(this.table);
        if (this.containerTable != null || this.value != null && this.valueField != null && this.tableDis != null && this.tableMap != null) {
            queryBuf.append(", (SELECT ");
            queryBuf.append(this.containerTable != null ? this.containerTable : this.tableMap).append(".item_id");
            queryBuf.append(" FROM ");
            this.buildFocusedSelectTables(queryBuf);
            queryBuf.append(" WHERE ");
            this.buildFocusedSelectClauses(queryBuf, params);
            queryBuf.append(") mappings");
        }
        queryBuf.append(" ");
    }

    private void buildSelectStatementDistinct(StringBuffer queryBuf, List params) throws BrowseException {
        if (queryBuf.length() == 0) {
            throw new BrowseException("No arguments for SELECT statement");
        }
        if (this.table == null || "".equals(this.table)) {
            throw new BrowseException("No table for SELECT statement");
        }
        queryBuf.insert(0, "SELECT ");
        queryBuf.append(" FROM ");
        queryBuf.append(this.table);
        if (this.containerTable != null && this.tableMap != null) {
            queryBuf.append(", (SELECT DISTINCT ").append(this.tableMap).append(".distinct_id ");
            queryBuf.append(" FROM ");
            this.buildFocusedSelectTables(queryBuf);
            queryBuf.append(" WHERE ");
            this.buildFocusedSelectClauses(queryBuf, params);
            queryBuf.append(") mappings");
        }
        queryBuf.append(" ");
    }

    private void buildWhereClauseDistinctConstraints(StringBuffer queryBuf, List params) {
        if (this.containerIDField != null && this.containerID != -1 && this.containerTable != null) {
            this.buildWhereClauseOpInsert(queryBuf);
            queryBuf.append(" ").append(this.table).append(".id=mappings.distinct_id ");
        }
    }

    private void buildWhereClauseJumpTo(StringBuffer queryBuf, List params) {
        String focusComparator = this.getFocusComparator();
        if (this.focusField != null && this.focusValue != null) {
            this.buildWhereClauseOpInsert(queryBuf);
            queryBuf.append(" ");
            queryBuf.append(this.focusField);
            queryBuf.append(focusComparator);
            queryBuf.append("? ");
            if (this.focusField.startsWith("sort_")) {
                params.add(this.utils.truncateSortValue(this.focusValue));
            } else {
                params.add(this.utils.truncateValue(this.focusValue));
            }
        }
    }

    private void buildWhereClauseFullConstraints(StringBuffer queryBuf, List params) {
        if ((this.tableDis == null || this.tableMap == null) && this.containerIDField != null && this.containerID != -1) {
            this.buildWhereClauseOpInsert(queryBuf);
            queryBuf.append(" ").append(this.table).append(".item_id=mappings.item_id ");
        }
    }

    private void buildWhereClauseFilterValue(StringBuffer queryBuf, List params) {
        if (this.value != null && this.valueField != null) {
            this.buildWhereClauseOpInsert(queryBuf);
            queryBuf.append(" ");
            if (this.tableDis != null && this.tableMap != null) {
                queryBuf.append(this.table).append(".item_id=mappings.item_id ");
            } else {
                queryBuf.append(this.valueField);
                if (this.valuePartial) {
                    queryBuf.append(" LIKE ? ");
                    if (this.valueField.startsWith("sort_")) {
                        params.add("%" + this.utils.truncateSortValue(this.value) + "%");
                    } else {
                        params.add("%" + this.utils.truncateValue(this.value) + "%");
                    }
                } else {
                    queryBuf.append("=? ");
                    if (this.valueField.startsWith("sort_")) {
                        params.add(this.utils.truncateSortValue(this.value));
                    } else {
                        params.add(this.utils.truncateValue(this.value));
                    }
                }
            }
        }
    }

    private void buildWhereClauseOpInsert(StringBuffer queryBuf) {
        queryBuf.append(this.whereClauseOperator);
        this.whereClauseOperator = " AND ";
    }

    private void buildWhereClauseOpReset() {
        this.whereClauseOperator = " WHERE ";
    }

    private String getFocusComparator() {
        String equals = "=";
        if (!this.useEqualsComparator()) {
            equals = "";
        }
        String focusComparator = "";
        focusComparator = this.isAscending() ? ">" + equals : "<" + equals;
        return focusComparator;
    }

    private String getQuery() throws BrowseException {
        if ("".equals(this.querySql) || this.rebuildQuery) {
            this.queryParams.clear();
            this.querySql = this.isDistinct() ? this.buildDistinctQuery(this.queryParams) : this.buildQuery(this.queryParams);
            this.rebuildQuery = false;
        }
        return this.querySql;
    }

    private Object[] getQueryParams() throws BrowseException {
        if ("".equals(this.querySql) || this.rebuildQuery) {
            this.getQuery();
        }
        return this.queryParams.toArray();
    }
}

