/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumHistoryDAO;
import org.dspace.checker.ChecksumResultDAO;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;

public final class ResultsPruner {
    private static final Logger LOG = Logger.getLogger(ResultsPruner.class);
    private long defaultDuration = 31536000000L;
    Map interests = new HashMap();
    private ChecksumResultDAO checksumResultDAO = new ChecksumResultDAO();
    private ChecksumHistoryDAO checksumHistoryDAO = new ChecksumHistoryDAO();

    public static ResultsPruner getDefaultPruner() {
        try {
            return ResultsPruner.getPruner(ConfigurationManager.getProperties());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("VeryExceptionalException - config file not there! ", e);
        }
    }

    public static ResultsPruner getPruner(String propsFile) throws FileNotFoundException {
        Properties props = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propsFile);
            props.load(fin);
            ResultsPruner resultsPruner = ResultsPruner.getPruner(props);
            return resultsPruner;
        }
        catch (IOException e) {
            throw new RuntimeException("Problem loading properties file: " + e.getMessage(), e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)e);
                }
            }
        }
    }

    public static ResultsPruner getPruner(Properties props) throws FileNotFoundException {
        ResultsPruner rp = new ResultsPruner();
        Pattern retentionPattern = Pattern.compile("checker\\.retention\\.(.*)");
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            long duration;
            String name = (String)en.nextElement();
            Matcher matcher = retentionPattern.matcher(name);
            if (!matcher.matches()) continue;
            String resultCode = matcher.group(1);
            try {
                duration = Utils.parseDuration(props.getProperty(name));
            }
            catch (ParseException e) {
                throw new RuntimeException("Problem parsing duration: " + e.getMessage(), e);
            }
            if ("default".equals(resultCode)) {
                rp.setDefaultDuration(duration);
                continue;
            }
            rp.addInterested(resultCode, duration);
        }
        return rp;
    }

    public void addInterested(String result, long duration) {
        this.interests.put(result, new Long(duration));
    }

    public void addInterested(String result, String duration) throws ParseException {
        this.addInterested(result, Utils.parseDuration(duration));
    }

    public long getDefaultDuration() {
        return this.defaultDuration;
    }

    public int prune() {
        List codes = this.checksumResultDAO.listAllCodes();
        for (String code : codes) {
            if (this.interests.containsKey(code)) continue;
            this.interests.put(code, new Long(this.defaultDuration));
        }
        return this.checksumHistoryDAO.prune(this.interests);
    }

    public void setDefaultDuration(long defaultDuration) {
        this.defaultDuration = defaultDuration;
    }
}

