/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class METSDisseminationCrosswalk
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(METSDisseminationCrosswalk.class);
    private static final String METS_PACKAGER_PLUGIN = "METS";
    public static final Namespace MODS_NS = Namespace.getNamespace((String)"mods", (String)"http://www.loc.gov/mods/v3");
    private static final Namespace XLINK_NS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/TR/xlink");
    private static Namespace METS_NS = Namespace.getNamespace((String)"mets", (String)"http://www.loc.gov/METS/");
    private static final Namespace[] namespaces = new Namespace[]{METS_NS, MODS_NS, XLINK_NS};
    private static final String METS_XSD = "http://www.loc.gov/standards/mets/mets.xsd";
    private static final String schemaLocation = METS_NS.getURI() + " " + "http://www.loc.gov/standards/mets/mets.xsd";
    private static XMLOutputter outputUgly = new XMLOutputter();
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private static SAXBuilder builder = new SAXBuilder();

    public Namespace[] getNamespaces() {
        return namespaces;
    }

    public String getSchemaLocation() {
        return schemaLocation;
    }

    public List disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(dso));
        return result;
    }

    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("METSDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, METS_PACKAGER_PLUGIN);
        if (dip == null) {
            throw new CrosswalkInternalException("Cannot find a disseminate plugin for package=METS");
        }
        try {
            PackageParameters pparams = new PackageParameters();
            pparams.put("manifestOnly", "true");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Context context = new Context();
            dip.disseminate(context, item, pparams, baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            try {
                SAXBuilder builder = new SAXBuilder();
                Document metsDocument = builder.build((InputStream)bais);
                return metsDocument.getRootElement();
            }
            catch (JDOMException je) {
                throw new MetadataValidationException("Error parsing METS: ", je);
            }
        }
        catch (PackageException pe) {
            throw new CrosswalkInternalException("Failed making METS manifest in packager: ", pe);
        }
    }

    public boolean canDisseminate(DSpaceObject dso) {
        return true;
    }

    public boolean preferList() {
        return false;
    }
}

