/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.HarvestedItemInfo;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Harvest {
    private static Logger log = Logger.getLogger(Harvest.class);

    public static List harvest(Context context, DSpaceObject scope, String startDate, String endDate, int offset, int limit, boolean items, boolean collections, boolean withdrawn) throws SQLException, ParseException {
        String query = "SELECT DISTINCT handle.handle, handle.resource_id, item.withdrawn, item.last_modified FROM handle, item";
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        if (scope != null) {
            if (scope.getType() == 3) {
                query = query + ", collection2item";
            } else if (scope.getType() == 4) {
                query = query + ", communities2item";
            }
        }
        query = query + " WHERE handle.resource_type_id=2 AND handle.resource_id=item.item_id ";
        if (scope != null) {
            if (scope.getType() == 3) {
                query = query + " AND collection2item.collection_id= ?  AND collection2item.item_id=handle.resource_id ";
                parameters.add(new Integer(scope.getID()));
            } else if (scope.getType() == 4) {
                query = query + " AND communities2item.community_id= ?  AND communities2item.item_id=handle.resource_id";
                parameters.add(new Integer(scope.getID()));
            }
        }
        if (startDate != null) {
            query = query + " AND item.last_modified >= ? ";
            parameters.add(Harvest.toTimestamp(startDate, false));
        }
        if (endDate != null) {
            boolean selfGenerated = false;
            if (endDate.length() == 20) {
                endDate = endDate.substring(0, 19) + ".999Z";
                selfGenerated = true;
            }
            query = query + " AND item.last_modified <= ? ";
            parameters.add(Harvest.toTimestamp(endDate, selfGenerated));
        }
        if (!withdrawn) {
            query = "oracle".equals(ConfigurationManager.getProperty("db.name")) ? query + " AND withdrawn=0 " : query + " AND withdrawn=false ";
        }
        query = query + " ORDER BY handle.resource_id";
        log.debug((Object)LogManager.getHeader(context, "harvest SQL", query));
        Object[] parametersArray = parameters.toArray();
        TableRowIterator tri = DatabaseManager.query(context, query, parametersArray);
        LinkedList<HarvestedItemInfo> infoObjects = new LinkedList<HarvestedItemInfo>();
        int index = 0;
        while (tri.hasNext()) {
            TableRow row = tri.next();
            if (index >= offset && (limit == 0 || index < offset + limit)) {
                HarvestedItemInfo itemInfo = new HarvestedItemInfo();
                itemInfo.context = context;
                itemInfo.handle = row.getStringColumn("handle");
                itemInfo.itemID = row.getIntColumn("resource_id");
                itemInfo.datestamp = row.getDateColumn("last_modified");
                itemInfo.withdrawn = row.getBooleanColumn("withdrawn");
                if (collections) {
                    Harvest.fillCollections(context, itemInfo);
                }
                if (items) {
                    itemInfo.item = Item.find(context, itemInfo.itemID);
                }
                infoObjects.add(itemInfo);
            }
            ++index;
        }
        tri.close();
        return infoObjects;
    }

    public static HarvestedItemInfo getSingle(Context context, String handle, boolean collections) throws SQLException {
        Item i = (Item)HandleManager.resolveToObject(context, handle);
        if (i == null) {
            return null;
        }
        HarvestedItemInfo itemInfo = new HarvestedItemInfo();
        itemInfo.context = context;
        itemInfo.item = i;
        itemInfo.handle = handle;
        itemInfo.withdrawn = i.isWithdrawn();
        itemInfo.datestamp = i.getLastModified();
        itemInfo.itemID = i.getID();
        if (collections) {
            Harvest.fillCollections(context, itemInfo);
        }
        return itemInfo;
    }

    private static void fillCollections(Context context, HarvestedItemInfo itemInfo) throws SQLException {
        TableRowIterator colRows = DatabaseManager.query(context, "SELECT handle.handle FROM handle, collection2item WHERE handle.resource_type_id= ? AND collection2item.collection_id=handle.resource_id AND collection2item.item_id = ? ", 3, itemInfo.itemID);
        itemInfo.collectionHandles = new LinkedList();
        while (colRows.hasNext()) {
            TableRow r = colRows.next();
            itemInfo.collectionHandles.add(r.getStringColumn("handle"));
        }
        colRows.close();
    }

    private static Timestamp toTimestamp(String t, boolean selfGenerated) throws ParseException {
        SimpleDateFormat df;
        if (t.length() == 10) {
            df = new SimpleDateFormat("yyyy-MM-dd");
        } else if (t.length() == 20) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        } else if (selfGenerated) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        } else {
            throw new ParseException("", 0);
        }
        df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        return new Timestamp(df.parse(t).getTime());
    }
}

