/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCSeriesNumber;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class DescribeStep
extends AbstractProcessingStep {
    private static Logger log = Logger.getLogger(DescribeStep.class);
    private static DCInputsReader inputsReader;
    public static final int STATUS_MORE_INPUT_REQUESTED = 1;
    public static final int STATUS_MISSING_REQUIRED_FIELDS = 2;

    public DescribeStep() throws ServletException {
        DescribeStep.getInputsReader();
    }

    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, NEXT_BUTTON);
        Item item = subInfo.getSubmissionItem().getItem();
        int currentPage = DescribeStep.getCurrentPage(request);
        Collection c = subInfo.getSubmissionItem().getCollection();
        DCInput[] inputs = inputsReader.getInputs(c.getHandle()).getPageRows(currentPage - 1, subInfo.getSubmissionItem().hasMultipleTitles(), subInfo.getSubmissionItem().isPublishedBefore());
        for (int i = 0; i < inputs.length; ++i) {
            String qualifier = inputs[i].getQualifier();
            if (qualifier == null && inputs[i].getInputType().equals("qualdrop_value")) {
                qualifier = "*";
            }
            item.clearMetadata(inputs[i].getSchema(), inputs[i].getElement(), qualifier, "*");
        }
        boolean moreInput = false;
        for (int j = 0; j < inputs.length; ++j) {
            String element = inputs[j].getElement();
            String qualifier = inputs[j].getQualifier();
            String schema = inputs[j].getSchema();
            String fieldName = qualifier != null && !qualifier.equals("*") ? schema + "_" + element + '_' + qualifier : schema + "_" + element;
            String inputType = inputs[j].getInputType();
            if (inputType.equals("name")) {
                this.readNames(request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("date")) {
                this.readDate(request, item, schema, element, qualifier);
            } else if (inputType.equals("series")) {
                this.readSeriesNumbers(request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("qualdrop_value")) {
                List quals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_qualifier");
                List vals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_value");
                for (int z = 0; z < vals.size(); ++z) {
                    String thisQual = (String)quals.get(z);
                    if ("".equals(thisQual)) {
                        thisQual = null;
                    }
                    String thisVal = (String)vals.get(z);
                    if (buttonPressed.equals("submit_" + schema + "_" + element + "_remove_" + z) || thisVal.equals("")) continue;
                    item.addMetadata(schema, element, thisQual, null, thisVal);
                }
            } else if (inputType.equals("dropdown") || inputType.equals("list")) {
                String[] vals = request.getParameterValues(fieldName);
                if (vals != null) {
                    for (int z = 0; z < vals.length; ++z) {
                        if (vals[z].equals("")) continue;
                        item.addMetadata(schema, element, qualifier, "en", vals[z]);
                    }
                }
            } else if (inputType.equals("onebox") || inputType.equals("twobox") || inputType.equals("textarea")) {
                this.readText(request, item, schema, element, qualifier, inputs[j].getRepeatable(), "en");
            } else {
                throw new ServletException("Field " + fieldName + " has an unknown input type: " + inputType);
            }
            if (moreInput || !buttonPressed.equals("submit_" + fieldName + "_add")) continue;
            subInfo.setMoreBoxesFor(fieldName);
            subInfo.setJumpToField(fieldName);
            moreInput = true;
        }
        DescribeStep.clearErrorFields(request);
        for (int i = 0; i < inputs.length; ++i) {
            DCValue[] values = item.getMetadata(inputs[i].getSchema(), inputs[i].getElement(), inputs[i].getQualifier(), "*");
            if (!inputs[i].isRequired() || values.length != 0) continue;
            DescribeStep.addErrorField(request, DescribeStep.getFieldName(inputs[i]));
        }
        subInfo.getSubmissionItem().update();
        context.commit();
        if (moreInput) {
            return 1;
        }
        if (DescribeStep.getErrorFields(request) != null && DescribeStep.getErrorFields(request).size() > 0) {
            return 2;
        }
        return STATUS_COMPLETE;
    }

    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        if (inputsReader == null) {
            inputsReader = new DCInputsReader();
        }
        String collectionHandle = "default";
        if (subInfo.getSubmissionItem() != null) {
            collectionHandle = subInfo.getSubmissionItem().getCollection().getHandle();
        }
        return inputsReader.getNumberInputPages(collectionHandle);
    }

    public static DCInputsReader getInputsReader() throws ServletException {
        if (inputsReader == null) {
            inputsReader = new DCInputsReader();
        }
        return inputsReader;
    }

    protected void readNames(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        List<String> firsts = new LinkedList();
        List lasts = new LinkedList<String>();
        if (repeated) {
            String removeButton;
            firsts = this.getRepeatedParameter(request, metadataField, metadataField + "_first");
            lasts = this.getRepeatedParameter(request, metadataField, metadataField + "_last");
            String buttonPressed = Util.getSubmitButton(request, "");
            if (buttonPressed.startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                firsts.remove(valToRemove);
                lasts.remove(valToRemove);
            }
        } else {
            String lastName = request.getParameter(metadataField + "_last");
            String firstNames = request.getParameter(metadataField + "_first");
            if (lastName != null) {
                lasts.add(lastName);
            }
            if (firstNames != null) {
                firsts.add(firstNames);
            }
        }
        item.clearMetadata(schema, element, qualifier, "*");
        for (int i = 0; i < lasts.size(); ++i) {
            int comma;
            String f = (String)firsts.get(i);
            String l = (String)lasts.get(i);
            if (l == null || l.trim().equals("")) continue;
            if (f == null) {
                f = "";
            }
            if ((comma = l.indexOf(44)) >= 0) {
                f = f + l.substring(comma + 1);
                l = l.substring(0, comma);
                while (f.startsWith(" ")) {
                    f = f.substring(1);
                }
            }
            item.addMetadata(schema, element, qualifier, null, new DCPersonName(l, f).toString());
        }
    }

    protected void readText(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated, String lang) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        List<String> vals = new LinkedList();
        if (repeated) {
            String removeButton;
            vals = this.getRepeatedParameter(request, metadataField, metadataField);
            String buttonPressed = Util.getSubmitButton(request, "");
            if (buttonPressed.startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                vals.remove(valToRemove);
            }
        } else {
            String value = request.getParameter(metadataField);
            if (value != null) {
                vals.add(value.trim());
            }
        }
        item.clearMetadata(schema, element, qualifier, "*");
        for (int i = 0; i < vals.size(); ++i) {
            String s = (String)vals.get(i);
            if (s == null || s.equals("")) continue;
            item.addMetadata(schema, element, qualifier, lang, s);
        }
    }

    protected void readDate(HttpServletRequest request, Item item, String schema, String element, String qualifier) throws SQLException {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        int year = Util.getIntParameter(request, metadataField + "_year");
        int month = Util.getIntParameter(request, metadataField + "_month");
        int day = Util.getIntParameter(request, metadataField + "_day");
        DCDate d = new DCDate();
        d.setDateLocal(year, month, day, -1, -1, -1);
        item.clearMetadata(schema, element, qualifier, "*");
        if (year > 0) {
            item.addMetadata(schema, element, qualifier, null, d.toString());
        }
    }

    protected void readSeriesNumbers(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        List<String> series = new LinkedList();
        List<String> numbers = new LinkedList();
        if (repeated) {
            String removeButton;
            series = this.getRepeatedParameter(request, metadataField, metadataField + "_series");
            numbers = this.getRepeatedParameter(request, metadataField, metadataField + "_number");
            String buttonPressed = Util.getSubmitButton(request, "");
            if (buttonPressed.startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                series.remove(valToRemove);
                numbers.remove(valToRemove);
            }
        } else {
            String s = request.getParameter(metadataField + "_series");
            String n = request.getParameter(metadataField + "_number");
            if (s != null && !s.equals("")) {
                if (n == null) {
                    n = "";
                }
                series.add(s);
                numbers.add(n);
            }
        }
        item.clearMetadata(schema, element, qualifier, "*");
        for (int i = 0; i < series.size(); ++i) {
            String s = ((String)series.get(i)).trim();
            String n = ((String)numbers.get(i)).trim();
            if (s.equals("") && n.equals("")) continue;
            item.addMetadata(schema, element, qualifier, null, new DCSeriesNumber(s, n).toString());
        }
    }

    protected List getRepeatedParameter(HttpServletRequest request, String metadataField, String param) {
        LinkedList<String> vals = new LinkedList<String>();
        int i = 0;
        boolean foundLast = false;
        log.debug((Object)("getRepeatedParameter: metadataField=" + metadataField + " param=" + metadataField));
        while (!foundLast) {
            String s = null;
            s = i == 0 ? request.getParameter(param) : request.getParameter(param + "_" + i);
            if (s != null) {
                boolean addValue = true;
                String[] selected = request.getParameterValues(metadataField + "_selected");
                if (selected != null) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!selected[j].equals(metadataField + "_" + i)) continue;
                        addValue = false;
                    }
                }
                if (addValue) {
                    vals.add(s.trim());
                }
            } else {
                foundLast = true;
            }
            ++i;
        }
        return vals;
    }

    public static String getFieldName(DCInput input) {
        String dcSchema = input.getSchema();
        String dcElement = input.getElement();
        String dcQualifier = input.getQualifier();
        if (dcQualifier != null && !dcQualifier.equals("*")) {
            return dcSchema + "_" + dcElement + '_' + dcQualifier;
        }
        return dcSchema + "_" + dcElement;
    }
}

