/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;

public class ItemExport {
    private static final int SUBDIR_LIMIT = 0;

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "type", true, "type: COLLECTION or ITEM");
        options.addOption("i", "id", true, "ID or handle of thing to export");
        options.addOption("d", "dest", true, "destination where you want items to go");
        options.addOption("n", "number", true, "sequence number to begin exporting items with");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        String typeString = null;
        String destDirName = null;
        String myIDString = null;
        int seqStart = -1;
        int myType = -1;
        Item myItem = null;
        Collection mycollection = null;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("ItemExport\n", options);
            System.out.println("\nfull collection: ItemExport -t COLLECTION -i ID -d dest -n number");
            System.out.println("singleitem:       ItemExport -t ITEM -i ID -d dest -n number");
            System.exit(0);
        }
        if (line.hasOption('t')) {
            typeString = line.getOptionValue('t');
            if (typeString.equals("ITEM")) {
                myType = 2;
            } else if (typeString.equals("COLLECTION")) {
                myType = 3;
            }
        }
        if (line.hasOption('i')) {
            myIDString = line.getOptionValue('i');
        }
        if (line.hasOption('d')) {
            destDirName = line.getOptionValue('d');
        }
        if (line.hasOption('n')) {
            seqStart = Integer.parseInt(line.getOptionValue('n'));
        }
        if (myType == -1) {
            System.out.println("type must be either COLLECTION or ITEM (-h for help)");
            System.exit(1);
        }
        if (destDirName == null) {
            System.out.println("destination directory must be set (-h for help)");
            System.exit(1);
        }
        if (seqStart == -1) {
            System.out.println("sequence start number must be set (-h for help)");
            System.exit(1);
        }
        if (myIDString == null) {
            System.out.println("ID must be set to either a database ID or a handle (-h for help)");
            System.exit(1);
        }
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        if (myType == 2) {
            if (myIDString.indexOf(47) != -1) {
                myItem = (Item)HandleManager.resolveToObject(c, myIDString);
                if (myItem == null || myItem.getType() != 2) {
                    myItem = null;
                }
            } else {
                myItem = Item.find(c, Integer.parseInt(myIDString));
            }
            if (myItem == null) {
                System.out.println("Error, item cannot be found: " + myIDString);
            }
        } else {
            if (myIDString.indexOf(47) != -1) {
                mycollection = (Collection)HandleManager.resolveToObject(c, myIDString);
                if (mycollection == null || mycollection.getType() != 3) {
                    mycollection = null;
                }
            } else if (myIDString != null) {
                mycollection = Collection.find(c, Integer.parseInt(myIDString));
            }
            if (mycollection == null) {
                System.out.println("Error, collection cannot be found: " + myIDString);
                System.exit(1);
            }
        }
        if (myItem != null) {
            ItemExport.exportItem(c, myItem, destDirName, seqStart);
        } else {
            System.out.println("Exporting from collection: " + myIDString);
            ItemIterator i = mycollection.getItems();
            ItemExport.exportItem(c, i, destDirName, seqStart);
        }
        c.complete();
    }

    private static void exportItem(Context c, ItemIterator i, String destDirName, int seqStart) throws Exception {
        int mySequenceNumber = seqStart;
        int counter = -1;
        boolean subDirSuffix = false;
        String fullPath = destDirName;
        String subdir = "";
        System.out.println("Beginning export");
        while (i.hasNext()) {
            System.out.println("Exporting item to " + mySequenceNumber);
            ItemExport.exportItem(c, i.next(), fullPath, mySequenceNumber);
            ++mySequenceNumber;
        }
    }

    private static void exportItem(Context c, Item myItem, String destDirName, int seqStart) throws Exception {
        File itemDir;
        File destDir = new File(destDirName);
        if (destDir.exists()) {
            itemDir = new File(destDir + "/" + seqStart);
            System.out.println("Exporting Item " + myItem.getID() + " to " + itemDir);
            if (itemDir.exists()) {
                throw new Exception("Directory " + destDir + "/" + seqStart + " already exists!");
            }
            if (!itemDir.mkdir()) {
                throw new Exception("Error, can't make dir " + itemDir);
            }
        } else {
            throw new Exception("Error, directory " + destDirName + " doesn't exist!");
        }
        ItemExport.writeMetadata(c, myItem, itemDir);
        ItemExport.writeBitstreams(c, myItem, itemDir);
        ItemExport.writeHandle(c, myItem, itemDir);
    }

    private static void writeMetadata(Context c, Item i, File destDir) throws Exception {
        HashMap map = new HashMap();
        DCValue[] dcorevalues = i.getMetadata("*", "*", "*", "*");
        for (int ii = 0; ii < dcorevalues.length; ++ii) {
            map.put(dcorevalues[ii].schema, null);
        }
        for (String schema : map.keySet()) {
            ItemExport.writeMetadata(c, schema, i, destDir);
        }
    }

    private static void writeMetadata(Context c, String schema, Item i, File destDir) throws Exception {
        byte[] utf8;
        BufferedOutputStream out;
        String filename = schema.equals("dc") ? "dublin_core.xml" : "metadata_" + schema + ".xml";
        File outFile = new File(destDir, filename);
        System.out.println("Attempting to create file " + outFile);
        if (outFile.createNewFile()) {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            DCValue[] dcorevalues = i.getMetadata(schema, "*", "*", "*");
            utf8 = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n".getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dcTag = "<dublin_core schema=\"" + schema + "\">\n";
            utf8 = dcTag.getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            for (int j = 0; j < dcorevalues.length; ++j) {
                DCValue dcv = dcorevalues[j];
                String qualifier = dcv.qualifier;
                if (qualifier == null) {
                    qualifier = "none";
                }
                utf8 = ("  <dcvalue element=\"" + dcv.element + "\" " + "qualifier=\"" + qualifier + "\">" + Utils.addEntities(dcv.value) + "</dcvalue>\n").getBytes("UTF-8");
                out.write(utf8, 0, utf8.length);
            }
        } else {
            throw new Exception("Cannot create dublin_core.xml in " + destDir);
        }
        utf8 = "</dublin_core>\n".getBytes("UTF-8");
        out.write(utf8, 0, utf8.length);
        out.close();
    }

    private static void writeHandle(Context c, Item i, File destDir) throws Exception {
        String filename = "handle";
        File outFile = new File(destDir, filename);
        if (!outFile.createNewFile()) {
            throw new Exception("Cannot create file " + filename + " in " + destDir);
        }
        PrintWriter out = new PrintWriter(new FileWriter(outFile));
        out.println(i.getHandle());
        out.close();
    }

    private static void writeBitstreams(Context c, Item i, File destDir) throws Exception {
        PrintWriter out;
        File outFile = new File(destDir, "contents");
        if (outFile.createNewFile()) {
            out = new PrintWriter(new FileWriter(outFile));
            Bundle[] bundles = i.getBundles();
            for (int j = 0; j < bundles.length; ++j) {
                Bitstream[] bitstreams = bundles[j].getBitstreams();
                String bundleName = bundles[j].getName();
                for (int k = 0; k < bitstreams.length; ++k) {
                    String myName;
                    Bitstream b = bitstreams[k];
                    String oldName = myName = b.getName();
                    int myPrefix = 1;
                    InputStream is = b.retrieve();
                    boolean isDone = false;
                    while (!isDone) {
                        File fout = new File(destDir, myName);
                        if (fout.createNewFile()) {
                            FileOutputStream fos = new FileOutputStream(fout);
                            Utils.bufferedCopy(is, fos);
                            is.close();
                            fos.close();
                            if (b.isRegisteredBitstream()) {
                                out.println("-r -s " + b.getStoreNumber() + " -f " + myName + "\tbundle:" + bundleName);
                            } else {
                                out.println(myName + "\tbundle:" + bundleName);
                            }
                            isDone = true;
                            continue;
                        }
                        myName = myPrefix + "_" + oldName;
                        ++myPrefix;
                    }
                }
            }
        } else {
            throw new Exception("Cannot create contents in " + destDir);
        }
        out.close();
    }
}

