/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.mediafilter.FormatFilter;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSIndexer;

public class MediaFilterManager {
    public static String MEDIA_FILTER_PLUGINS_KEY = "filter.plugins";
    public static String FILTER_PREFIX = "filter";
    public static String INPUT_FORMATS_SUFFIX = "inputFormats";
    public static boolean updateIndex = true;
    public static boolean isVerbose = false;
    public static boolean isForce = false;
    public static String identifier = null;
    public static int max2Process = Integer.MAX_VALUE;
    public static int processed = 0;
    private static Item currentItem = null;
    private static FormatFilter[] filterClasses = null;
    private static Map filterFormats = new HashMap();
    private static List skipList = null;
    public static String FILTER_PLUGIN_SEPARATOR = "\u001c";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        HelpFormatter myhelp;
        System.setProperty("java.awt.headless", "true");
        PosixParser parser = new PosixParser();
        int status = 0;
        Options options = new Options();
        options.addOption("v", "verbose", false, "print all extracted text and other details to STDOUT");
        options.addOption("f", "force", false, "force all bitstreams to be processed");
        options.addOption("n", "noindex", false, "do NOT update the search index after filtering bitstreams");
        options.addOption("i", "identifier", true, "ONLY process bitstreams belonging to identifier");
        options.addOption("m", "maximum", true, "process no more than maximum items");
        options.addOption("h", "help", false, "help");
        OptionBuilder.withLongOpt((String)"plugins");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)("ONLY run the specified Media Filter plugin(s)\nlisted from '" + MEDIA_FILTER_PLUGINS_KEY + "' in dspace.cfg.\n" + "Separate multiple with a comma (,)\n" + "(e.g. MediaFilterManager -p \n\"Word Text Extractor\",\"PDF Text Extractor\")"));
        Option pluginOption = OptionBuilder.create((char)'p');
        pluginOption.setArgs(-2);
        options.addOption(pluginOption);
        OptionBuilder.withLongOpt((String)"skip");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"SKIP the bitstreams belonging to identifier\nSeparate multiple identifiers with a comma (,)\n(e.g. MediaFilterManager -s \n 123456789/34,123456789/323)");
        Option skipOption = OptionBuilder.create((char)'s');
        skipOption.setArgs(-2);
        options.addOption(skipOption);
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (MissingArgumentException e) {
            System.out.println("ERROR: " + e.getMessage());
            myhelp = new HelpFormatter();
            myhelp.printHelp("MediaFilterManager\n", options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            HelpFormatter myhelp2 = new HelpFormatter();
            myhelp2.printHelp("MediaFilterManager\n", options);
            System.exit(0);
        }
        if (line.hasOption('v')) {
            isVerbose = true;
        }
        if (line.hasOption('n')) {
            updateIndex = false;
        }
        if (line.hasOption('f')) {
            isForce = true;
        }
        if (line.hasOption('i')) {
            identifier = line.getOptionValue('i');
        }
        if (line.hasOption('m') && (max2Process = Integer.parseInt(line.getOptionValue('m'))) <= 1) {
            System.out.println("Invalid maximum value '" + line.getOptionValue('m') + "' - ignoring");
            max2Process = Integer.MAX_VALUE;
        }
        String[] filterNames = null;
        if (line.hasOption('p')) {
            filterNames = line.getOptionValues('p');
            if (filterNames == null || filterNames.length == 0) {
                System.err.println("\nERROR: -p (-plugin) option requires at least one plugin to be specified.\n(e.g. MediaFilterManager -p \"Word Text Extractor\",\"PDF Text Extractor\")\n");
                myhelp = new HelpFormatter();
                myhelp.printHelp("MediaFilterManager\n", options);
                System.exit(1);
            }
        } else {
            String enabledPlugins = ConfigurationManager.getProperty(MEDIA_FILTER_PLUGINS_KEY);
            filterNames = enabledPlugins.split(",\\s*");
        }
        ArrayList<FormatFilter> filterList = new ArrayList<FormatFilter>();
        for (int i = 0; i < filterNames.length; ++i) {
            String formats;
            FormatFilter filter = (FormatFilter)PluginManager.getNamedPlugin(FormatFilter.class, filterNames[i]);
            if (filter == null) {
                System.err.println("\nERROR: Unknown MediaFilter specified (either from command-line or in dspace.cfg): '" + filterNames[i] + "'");
                System.exit(1);
                continue;
            }
            filterList.add(filter);
            String filterClassName = filter.getClass().getName();
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filter.getClass())) {
                pluginName = ((SelfNamedPlugin)((Object)filter)).getPluginInstanceName();
            }
            if ((formats = ConfigurationManager.getProperty(FILTER_PREFIX + "." + filterClassName + (pluginName != null ? "." + pluginName : "") + "." + INPUT_FORMATS_SUFFIX)) == null) continue;
            filterFormats.put(filterClassName + (pluginName != null ? FILTER_PLUGIN_SEPARATOR + pluginName : ""), Arrays.asList(formats.split(",[\\s]*")));
        }
        if (isVerbose) {
            System.out.println("The following MediaFilters are enabled: ");
            for (String filterName : filterFormats.keySet()) {
                System.out.println("Full Filter Name: " + filterName);
                String pluginName = null;
                if (filterName.contains(FILTER_PLUGIN_SEPARATOR)) {
                    String[] fields = filterName.split(FILTER_PLUGIN_SEPARATOR);
                    filterName = fields[0];
                    pluginName = fields[1];
                }
                System.out.println(filterName + (pluginName != null ? " (Plugin: " + pluginName + ")" : ""));
            }
        }
        filterClasses = filterList.toArray(new FormatFilter[filterList.size()]);
        String[] skipIds = null;
        if (line.hasOption('s')) {
            skipIds = line.getOptionValues('s');
            if (skipIds == null || skipIds.length == 0) {
                System.err.println("\nERROR: -s (-skip) option requires at least one identifier to SKIP.\nMake sure to separate multiple identifiers with a comma!\n(e.g. MediaFilterManager -s 123456789/34,123456789/323)\n");
                HelpFormatter myhelp3 = new HelpFormatter();
                myhelp3.printHelp("MediaFilterManager\n", options);
                System.exit(0);
            }
            skipList = Arrays.asList(skipIds);
        }
        Context c = null;
        try {
            c = new Context();
            c.setIgnoreAuthorization(true);
            if (identifier == null) {
                MediaFilterManager.applyFiltersAllItems(c);
            } else {
                DSpaceObject dso = HandleManager.resolveToObject(c, identifier);
                if (dso == null) {
                    throw new IllegalArgumentException("Cannot resolve " + identifier + " to a DSpace object");
                }
                switch (dso.getType()) {
                    case 4: {
                        MediaFilterManager.applyFiltersCommunity(c, (Community)dso);
                        break;
                    }
                    case 3: {
                        MediaFilterManager.applyFiltersCollection(c, (Collection)dso);
                        break;
                    }
                    case 2: {
                        MediaFilterManager.applyFiltersItem(c, (Item)dso);
                    }
                }
            }
            if (updateIndex) {
                System.out.println("Updating search index:");
                DSIndexer.updateIndex(c);
            }
            c.complete();
            c = null;
        }
        catch (Exception e) {
            status = 1;
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
        System.exit(status);
    }

    public static void applyFiltersAllItems(Context c) throws Exception {
        if (skipList != null) {
            Community[] topLevelCommunities = Community.findAllTop(c);
            for (int i = 0; i < topLevelCommunities.length; ++i) {
                MediaFilterManager.applyFiltersCommunity(c, topLevelCommunities[i]);
            }
        } else {
            ItemIterator i = Item.findAll(c);
            while (i.hasNext() && processed < max2Process) {
                MediaFilterManager.applyFiltersItem(c, i.next());
            }
        }
    }

    public static void applyFiltersCommunity(Context c, Community community) throws Exception {
        if (!MediaFilterManager.inSkipList(community.getHandle())) {
            Community[] subcommunities = community.getSubcommunities();
            for (int i = 0; i < subcommunities.length; ++i) {
                MediaFilterManager.applyFiltersCommunity(c, subcommunities[i]);
            }
            Collection[] collections = community.getCollections();
            for (int j = 0; j < collections.length; ++j) {
                MediaFilterManager.applyFiltersCollection(c, collections[j]);
            }
        }
    }

    public static void applyFiltersCollection(Context c, Collection collection) throws Exception {
        if (!MediaFilterManager.inSkipList(collection.getHandle())) {
            ItemIterator i = collection.getItems();
            while (i.hasNext() && processed < max2Process) {
                MediaFilterManager.applyFiltersItem(c, i.next());
            }
        }
    }

    public static void applyFiltersItem(Context c, Item item) throws Exception {
        if (!MediaFilterManager.inSkipList(item.getHandle())) {
            currentItem = item;
            if (MediaFilterManager.filterItem(c, item)) {
                c.commit();
                ++processed;
            }
            item.decache();
            currentItem = null;
        }
    }

    public static boolean filterItem(Context c, Item myItem) throws Exception {
        Bundle[] myBundles = myItem.getBundles("ORIGINAL");
        boolean done = false;
        for (int i = 0; i < myBundles.length; ++i) {
            Bitstream[] myBitstreams = myBundles[i].getBitstreams();
            for (int k = 0; k < myBitstreams.length; ++k) {
                done |= MediaFilterManager.filterBitstream(c, myItem, myBitstreams[k]);
            }
        }
        return done;
    }

    public static boolean filterBitstream(Context c, Item myItem, Bitstream myBitstream) throws Exception {
        boolean filtered = false;
        for (int i = 0; i < filterClasses.length; ++i) {
            List fmts;
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filterClasses[i].getClass())) {
                pluginName = ((SelfNamedPlugin)((Object)filterClasses[i])).getPluginInstanceName();
            }
            if (!(fmts = (List)filterFormats.get(filterClasses[i].getClass().getName() + (pluginName != null ? FILTER_PLUGIN_SEPARATOR + pluginName : ""))).contains(myBitstream.getFormat().getShortDescription())) continue;
            try {
                if (!MediaFilterManager.processBitstream(c, myItem, myBitstream, filterClasses[i])) continue;
                myItem.update();
                filtered = true;
                continue;
            }
            catch (Exception e) {
                String handle = myItem.getHandle();
                Bundle[] bundles = myBitstream.getBundles();
                String name = myBitstream.getName();
                long size = myBitstream.getSize();
                String checksum = myBitstream.getChecksum() + " (" + myBitstream.getChecksumAlgorithm() + ")";
                int assetstore = myBitstream.getStoreNumber();
                System.out.println("ERROR filtering, skipping bitstream:\n");
                System.out.println("\tItem Handle: " + handle);
                for (Bundle bundle : bundles) {
                    System.out.println("\tBundle Name: " + bundle.getName());
                }
                System.out.println("\tFile Size: " + size);
                System.out.println("\tChecksum: " + checksum);
                System.out.println("\tAsset Store: " + assetstore);
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return filtered;
    }

    public static boolean processBitstream(Context c, Item item, Bitstream source, FormatFilter formatFilter) throws Exception {
        if (!formatFilter.preProcessBitstream(c, item, source)) {
            return false;
        }
        boolean overWrite = isForce;
        String newName = formatFilter.getFilteredName(source.getName());
        Bitstream existingBitstream = null;
        Bundle targetBundle = null;
        Bundle[] bundles = item.getBundles(formatFilter.getBundleName());
        if (bundles.length > 0) {
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                for (int j = 0; j < bitstreams.length; ++j) {
                    if (!bitstreams[j].getName().equals(newName)) continue;
                    targetBundle = bundles[i];
                    existingBitstream = bitstreams[j];
                }
            }
        }
        if (!overWrite && existingBitstream != null) {
            System.out.println("SKIPPED: bitstream " + source.getID() + " because '" + newName + "' already exists");
            return false;
        }
        InputStream destStream = formatFilter.getDestinationStream(source.retrieve());
        if (destStream == null) {
            System.out.println("SKIPPED: bitstream " + source.getID() + " because of filtering error");
            return false;
        }
        targetBundle = bundles.length < 1 ? item.createBundle(formatFilter.getBundleName()) : bundles[0];
        Bitstream b = targetBundle.createBitstream(destStream);
        b.setName(newName);
        b.setSource("Written by FormatFilter " + formatFilter.getClass().getName() + " on " + DCDate.getCurrent() + " (GMT).");
        b.setDescription(formatFilter.getDescription());
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(c, formatFilter.getFormatString());
        b.setFormat(bf);
        b.update();
        AuthorizeManager.removeAllPolicies(c, b);
        AuthorizeManager.inheritPolicies(c, source, b);
        if (existingBitstream != null) {
            targetBundle.removeBitstream(existingBitstream);
        }
        System.out.println("FILTERED: bitstream " + source.getID() + " and created '" + newName + "'");
        formatFilter.postProcessBitstream(c, item, b);
        return true;
    }

    public static Item getCurrentItem() {
        return currentItem;
    }

    public static boolean inSkipList(String identifier) {
        if (skipList != null && skipList.contains(identifier)) {
            System.out.println("SKIP-LIST: skipped bitstreams within identifier " + identifier);
            return true;
        }
        return false;
    }
}

