/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);

    public static String nonBreakSpace(String s) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ' ') {
                newString.append("&nbsp;");
                continue;
            }
            newString.append(ch);
        }
        return newString.toString();
    }

    public static String encodeBitstreamName(String stringIn, String encoding) throws UnsupportedEncodingException {
        StringBuffer out = new StringBuffer();
        String[] pctEncoding = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
        byte[] bytes = stringIn.getBytes(encoding);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 45 || bytes[i] == 46 || bytes[i] == 95 || bytes[i] == 126 || bytes[i] == 47) {
                out.append((char)bytes[i]);
                continue;
            }
            if (bytes[i] >= 0) {
                out.append(pctEncoding[bytes[i]]);
                continue;
            }
            out.append(pctEncoding[256 + bytes[i]]);
        }
        log.debug((Object)("encoded \"" + stringIn + "\" to \"" + out.toString() + "\""));
        return out.toString();
    }

    public static String encodeBitstreamName(String stringIn) throws UnsupportedEncodingException {
        return Util.encodeBitstreamName(stringIn, "UTF-8");
    }

    public static String formatFileSize(double in) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("###,###.##");
        if (in < 1024.0) {
            df.applyPattern("0");
            return df.format(in) + " " + "B";
        }
        if (in < 1024000.0) {
            return df.format(in /= 1024.0) + " " + "kB";
        }
        if (in < 1.024E9) {
            return df.format(in /= 1024000.0) + " " + "MB";
        }
        return df.format(in /= 1.024E9) + " " + "GB";
    }

    public static int getIntParameter(HttpServletRequest request, String param) {
        String val = request.getParameter(param);
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int[] getIntParameters(HttpServletRequest request, String param) {
        String[] request_values = request.getParameterValues(param);
        if (request_values == null) {
            return null;
        }
        int[] return_values = new int[request_values.length];
        for (int x = 0; x < return_values.length; ++x) {
            try {
                return_values[x] = Integer.parseInt(request_values[x]);
                continue;
            }
            catch (Exception e) {
                return_values[x] = -1;
            }
        }
        return return_values;
    }

    public static boolean getBoolParameter(HttpServletRequest request, String param) {
        return request.getParameter(param) != null && request.getParameter(param).equals("true");
    }

    public static String getSubmitButton(HttpServletRequest request, String def) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            if (!parameterName.startsWith("submit")) continue;
            return parameterName;
        }
        return def;
    }
}

