/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import org.dspace.authenticate.IPMatcherException;

public class IPMatcher {
    private byte[] network = new byte[4];
    private byte[] netmask = new byte[]{-1, -1, -1, -1};

    public IPMatcher(String ipSpec) throws IPMatcherException {
        boolean mustHave4 = false;
        String ipPart = ipSpec;
        String[] parts = ipSpec.split("/");
        switch (parts.length) {
            case 2: {
                ipPart = parts[0];
                mustHave4 = true;
                String[] maskParts = parts[1].split("\\.");
                if (maskParts.length == 1) {
                    int x;
                    try {
                        x = Integer.parseInt(maskParts[0]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IPMatcherException("Malformed IP range specification " + ipSpec, nfe);
                    }
                    if (x < 0 || x > 32) {
                        throw new IPMatcherException();
                    }
                    int fullMask = -1 << 32 - x;
                    this.netmask[0] = (byte)((fullMask & 0xFF000000) >>> 24);
                    this.netmask[1] = (byte)((fullMask & 0xFF0000) >>> 16);
                    this.netmask[2] = (byte)((fullMask & 0xFF00) >>> 8);
                    this.netmask[3] = (byte)(fullMask & 0xFF);
                } else {
                    this.ipToBytes(parts[1], this.netmask, true);
                }
            }
            case 1: {
                int partCount = this.ipToBytes(ipPart, this.network, mustHave4);
                for (int i = 3; i >= partCount; --i) {
                    this.netmask[i] = 0;
                }
                break;
            }
            default: {
                throw new IPMatcherException("Malformed IP range specification " + ipSpec);
            }
        }
    }

    private int ipToBytes(String ip, byte[] bytes, boolean mustHave4) throws IPMatcherException {
        String[] parts = ip.split("\\.");
        if (parts.length > 4 || mustHave4 && parts.length != 4) {
            throw new IPMatcherException("Malformed IP specification " + ip);
        }
        try {
            for (int i = 0; i < parts.length; ++i) {
                int p = Integer.parseInt(parts[i]);
                if (p < 0 || p > 255) {
                    throw new IPMatcherException("Malformed IP specification " + ip);
                }
                bytes[i] = (byte)(p < 128 ? p : p - 256);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IPMatcherException("Malformed IP specification " + ip, nfe);
        }
        return parts.length;
    }

    public boolean match(String ipIn) throws IPMatcherException {
        byte[] bytes = new byte[4];
        this.ipToBytes(ipIn, bytes, true);
        for (int i = 0; i < 4; ++i) {
            if ((bytes[i] & this.netmask[i]) == (this.network[i] & this.netmask[i])) continue;
            return false;
        }
        return true;
    }
}

