/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.BitstreamInfoDAO;
import org.dspace.checker.ListDispatcher;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class HandleDispatcher
implements BitstreamDispatcher {
    private static final Logger LOG = Logger.getLogger(HandleDispatcher.class);
    String handle = null;
    Boolean init = Boolean.FALSE;
    ListDispatcher delegate = null;
    BitstreamInfoDAO bitstreamInfoDAO;

    private HandleDispatcher() {
    }

    public HandleDispatcher(BitstreamInfoDAO bitInfoDAO, String hdl) {
        this.bitstreamInfoDAO = bitInfoDAO;
        this.handle = hdl;
    }

    private void init() {
        Context context = null;
        int dsoType = -1;
        int id = -1;
        try {
            context = new Context();
            DSpaceObject dso = HandleManager.resolveToObject(context, this.handle);
            id = dso.getID();
            dsoType = dso.getType();
            context.abort();
        }
        catch (SQLException e) {
            LOG.error((Object)("init error " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("init error" + e.getMessage(), e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
        List<Integer> ids = new ArrayList<Integer>();
        switch (dsoType) {
            case 0: {
                ids.add(new Integer(id));
                break;
            }
            case 2: {
                ids = this.bitstreamInfoDAO.getItemBitstreams(id);
                break;
            }
            case 3: {
                ids = this.bitstreamInfoDAO.getCollectionBitstreams(id);
                break;
            }
            case 4: {
                ids = this.bitstreamInfoDAO.getCommunityBitstreams(id);
            }
        }
        this.delegate = new ListDispatcher(ids);
        this.init = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next() {
        Boolean bl = this.init;
        synchronized (bl) {
            if (this.init == Boolean.FALSE) {
                this.init();
            }
        }
        return this.delegate.next();
    }
}

