/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class MetadataField {
    private int fieldID = 0;
    private int schemaID = 0;
    private String element;
    private String qualifier;
    private String scopeNote;
    private static Logger log = Logger.getLogger(MetadataField.class);
    private TableRow row;
    private static HashMap id2field = null;

    public MetadataField() {
    }

    public MetadataField(MetadataSchema schema) {
        this.schemaID = schema.getSchemaID();
    }

    public MetadataField(MetadataSchema schema, String element, String qualifier, String scopeNote) {
        this.schemaID = schema.getSchemaID();
        this.element = element;
        this.qualifier = qualifier;
        this.scopeNote = scopeNote;
    }

    public MetadataField(int schemaID, int fieldID, String element, String qualifier, String scopeNote) {
        this.schemaID = schemaID;
        this.fieldID = fieldID;
        this.element = element;
        this.qualifier = qualifier;
        this.scopeNote = scopeNote;
    }

    public MetadataField(TableRow row) {
        if (row != null) {
            this.fieldID = row.getIntColumn("metadata_field_id");
            this.schemaID = row.getIntColumn("metadata_schema_id");
            this.element = row.getStringColumn("element");
            this.qualifier = row.getStringColumn("qualifier");
            this.scopeNote = row.getStringColumn("scope_note");
            this.row = row;
        }
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public int getSchemaID() {
        return this.schemaID;
    }

    public void setSchemaID(int schemaID) {
        this.schemaID = schemaID;
    }

    public String getScopeNote() {
        return this.scopeNote;
    }

    public void setScopeNote(String scopeNote) {
        this.scopeNote = scopeNote;
    }

    public void create(Context context) throws IOException, AuthorizeException, SQLException, NonUniqueMetadataException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.unique(context, this.schemaID, this.element, this.qualifier)) {
            throw new NonUniqueMetadataException("Please make " + this.element + "." + this.qualifier + " unique within schema #" + this.schemaID);
        }
        this.row = DatabaseManager.row("MetadataFieldRegistry");
        this.row.setColumn("metadata_schema_id", this.schemaID);
        this.row.setColumn("element", this.element);
        this.row.setColumn("qualifier", this.qualifier);
        this.row.setColumn("scope_note", this.scopeNote);
        DatabaseManager.insert(context, this.row);
        MetadataField.decache();
        this.fieldID = this.row.getIntColumn("metadata_field_id");
        log.info((Object)LogManager.getHeader(context, "create_metadata_field", "metadata_field_id=" + this.row.getIntColumn("metadata_field_id")));
    }

    public static MetadataField findByElement(Context context, int schemaID, String element, String qualifier) throws SQLException, AuthorizeException {
        TableRowIterator tri = qualifier == null ? DatabaseManager.queryTable(context, "MetadataFieldRegistry", "SELECT * FROM MetadataFieldRegistry WHERE metadata_schema_id= ? AND element= ?  AND qualifier is NULL ", schemaID, element) : DatabaseManager.queryTable(context, "MetadataFieldRegistry", "SELECT * FROM MetadataFieldRegistry WHERE metadata_schema_id= ? AND element= ?  AND qualifier= ? ", schemaID, element, qualifier);
        TableRow row = null;
        if (tri.hasNext()) {
            row = tri.next();
        }
        tri.close();
        if (row == null) {
            return null;
        }
        return new MetadataField(row);
    }

    public static MetadataField[] findAll(Context context) throws SQLException {
        ArrayList<MetadataField> fields = new ArrayList<MetadataField>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataFieldRegistry", "SELECT mfr.* FROM MetadataFieldRegistry mfr, MetadataSchemaRegistry msr where mfr.metadata_schema_id= msr.metadata_schema_id ORDER BY msr.short_id,  mfr.element, mfr.qualifier", new Object[0]);
        while (tri.hasNext()) {
            fields.add(new MetadataField(tri.next()));
        }
        tri.close();
        MetadataField[] typeArray = new MetadataField[fields.size()];
        return fields.toArray(typeArray);
    }

    public static MetadataField[] findAllInSchema(Context context, int schemaID) throws SQLException {
        ArrayList<MetadataField> fields = new ArrayList<MetadataField>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataFieldRegistry", "SELECT * FROM MetadataFieldRegistry WHERE metadata_schema_id= ?  ORDER BY element, qualifier", schemaID);
        while (tri.hasNext()) {
            fields.add(new MetadataField(tri.next()));
        }
        tri.close();
        MetadataField[] typeArray = new MetadataField[fields.size()];
        return fields.toArray(typeArray);
    }

    public void update(Context context) throws SQLException, AuthorizeException, NonUniqueMetadataException, IOException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modiffy the Dublin Core registry");
        }
        if (this.row.getIntColumn("metadata_schema_id") != this.schemaID && MetadataField.hasElement(context, this.schemaID, this.element, this.qualifier)) {
            throw new NonUniqueMetadataException("Duplcate field name found in target schema");
        }
        if (!this.unique(context, this.schemaID, this.element, this.qualifier)) {
            throw new NonUniqueMetadataException("Please make " + this.element + "." + this.qualifier);
        }
        this.row.setColumn("metadata_schema_id", this.schemaID);
        this.row.setColumn("element", this.element);
        this.row.setColumn("qualifier", this.qualifier);
        this.row.setColumn("scope_note", this.scopeNote);
        DatabaseManager.update(context, this.row);
        MetadataField.decache();
        log.info((Object)LogManager.getHeader(context, "update_metadatafieldregistry", "metadata_field_id=" + this.getFieldID() + "element=" + this.getElement() + "qualifier=" + this.getQualifier()));
    }

    private static boolean hasElement(Context context, int schemaID, String element, String qualifier) throws SQLException, AuthorizeException {
        return MetadataField.findByElement(context, schemaID, element, qualifier) != null;
    }

    public void delete(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        log.info((Object)LogManager.getHeader(context, "delete_metadata_field", "metadata_field_id=" + this.getFieldID()));
        DatabaseManager.delete(context, this.row);
        MetadataField.decache();
    }

    private boolean unique(Context context, int schemaID, String element, String qualifier) throws IOException, SQLException, AuthorizeException {
        Connection con = context.getDBConnection();
        TableRow reg = DatabaseManager.row("MetadataFieldRegistry");
        String qualifierClause = "";
        qualifierClause = qualifier == null ? "and qualifier is null" : "and qualifier = ?";
        String query = "SELECT COUNT(*) FROM " + reg.getTable() + " WHERE metadata_schema_id= ? " + " and metadata_field_id != ? " + " and element= ? " + qualifierClause;
        PreparedStatement statement = con.prepareStatement(query);
        statement.setInt(1, schemaID);
        statement.setInt(2, this.fieldID);
        statement.setString(3, element);
        if (qualifier != null) {
            statement.setString(4, qualifier);
        }
        ResultSet rs = statement.executeQuery();
        int count = 0;
        if (rs.next()) {
            count = rs.getInt(1);
        }
        return count == 0;
    }

    public static String formKey(String schema, String element, String qualifier) {
        if (qualifier == null) {
            return schema + "_" + element;
        }
        return schema + "_" + element + "_" + qualifier;
    }

    public static MetadataField find(Context context, int id) throws SQLException {
        MetadataField.initCache(context);
        Integer iid = new Integer(id);
        if (!id2field.containsKey(iid)) {
            return null;
        }
        return (MetadataField)id2field.get(iid);
    }

    private static void decache() {
        id2field = null;
    }

    private static void initCache(Context context) throws SQLException {
        if (id2field != null) {
            return;
        }
        id2field = new HashMap();
        log.info((Object)"Loading MetadataField elements into cache.");
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataFieldRegistry", "SELECT * from MetadataFieldRegistry", new Object[0]);
        while (tri.hasNext()) {
            TableRow row = tri.next();
            int fieldID = row.getIntColumn("metadata_field_id");
            id2field.put(new Integer(fieldID), new MetadataField(row));
        }
        tri.close();
    }
}

