/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class HandleManager {
    private static Logger log = Logger.getLogger(HandleManager.class);

    private HandleManager() {
    }

    public static String resolveToURL(Context context, String handle) throws SQLException {
        TableRow dbhandle = HandleManager.findHandleInternal(context, handle);
        if (dbhandle == null) {
            return null;
        }
        String url = ConfigurationManager.getProperty("dspace.url") + "/handle/" + handle;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved " + handle + " to " + url));
        }
        return url;
    }

    public static String getCanonicalForm(String handle) {
        String handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
        if (handlePrefix == null || handlePrefix.length() == 0) {
            handlePrefix = "http://hdl.handle.net/";
        }
        return handlePrefix + handle;
    }

    public static String createHandle(Context context, DSpaceObject dso) throws SQLException {
        TableRow handle = DatabaseManager.create(context, "Handle");
        String handleId = HandleManager.createId(handle.getIntColumn("handle_id"));
        handle.setColumn("handle", handleId);
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " " + handleId));
        }
        return handleId;
    }

    public static String createHandle(Context context, DSpaceObject dso, String suppliedHandle) throws SQLException {
        TableRow handle = DatabaseManager.create(context, "Handle");
        String handleId = suppliedHandle;
        handle.setColumn("handle", handleId);
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " " + handleId));
        }
        return handleId;
    }

    public static DSpaceObject resolveToObject(Context context, String handle) throws SQLException {
        TableRow dbhandle = HandleManager.findHandleInternal(context, handle);
        if (dbhandle == null) {
            return null;
        }
        if (dbhandle.isColumnNull("resource_type_id") || dbhandle.isColumnNull("resource_id")) {
            throw new IllegalStateException("No associated resource type");
        }
        int handletypeid = dbhandle.getIntColumn("resource_type_id");
        int resourceID = dbhandle.getIntColumn("resource_id");
        if (handletypeid == 2) {
            Item item = Item.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to item " + (item == null ? -1 : item.getID())));
            }
            return item;
        }
        if (handletypeid == 3) {
            Collection collection = Collection.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to collection " + (collection == null ? -1 : collection.getID())));
            }
            return collection;
        }
        if (handletypeid == 4) {
            Community community = Community.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to community " + (community == null ? -1 : community.getID())));
            }
            return community;
        }
        throw new IllegalStateException("Unsupported Handle Type " + Constants.typeText[handletypeid]);
    }

    public static String findHandle(Context context, DSpaceObject dso) throws SQLException {
        return HandleManager.getHandleInternal(context, dso.getType(), dso.getID());
    }

    static List getHandlesForPrefix(Context context, String prefix) throws SQLException {
        String sql = "SELECT handle FROM handle WHERE handle LIKE ? ";
        TableRowIterator iterator = DatabaseManager.queryTable(context, null, sql, prefix + "%");
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            TableRow row = iterator.next();
            results.add(row.getStringColumn("handle"));
        }
        iterator.close();
        return results;
    }

    private static String getHandleInternal(Context context, int type, int id) throws SQLException {
        String sql = "SELECT handle FROM Handle WHERE resource_type_id = ? AND resource_id = ?";
        TableRow row = DatabaseManager.querySingle(context, sql, type, id);
        return row == null ? null : row.getStringColumn("handle");
    }

    private static TableRow findHandleInternal(Context context, String handle) throws SQLException {
        if (handle == null) {
            throw new IllegalArgumentException("Handle is null");
        }
        return DatabaseManager.findByUnique(context, "Handle", "handle", handle);
    }

    private static String createId(int id) throws SQLException {
        String handlePrefix = ConfigurationManager.getProperty("handle.prefix");
        return new StringBuffer().append(handlePrefix).append(handlePrefix.endsWith("/") ? "" : "/").append(id).toString();
    }
}

