/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dspace.core.ConfigurationManager;

public class TableRow {
    private static final Object NULL_OBJECT = new Object();
    private String table;
    private Map data = new HashMap();
    private Map changed = new HashMap();

    public TableRow(String table, List columns) {
        this.table = table;
        this.nullColumns(columns);
        this.resetChanged(columns);
    }

    public String getTable() {
        return this.table;
    }

    public boolean hasColumn(String column) {
        return this.data.get(TableRow.canonicalize(column)) != null;
    }

    public boolean hasColumnChanged(String column) {
        return this.changed.get(TableRow.canonicalize(column)) == Boolean.TRUE;
    }

    public boolean isColumnNull(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        return this.data.get(TableRow.canonicalize(column)) == NULL_OBJECT;
    }

    public int getIntColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return -1;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value for " + column + " is not an integer");
        }
        return (Integer)value;
    }

    public long getLongColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return -1L;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("Value for " + column + " is not a long");
        }
        return (Long)value;
    }

    public String getStringColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return null;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Value is not an string");
        }
        return (String)value;
    }

    public boolean getBooleanColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return false;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            return i != 0;
        }
        throw new IllegalArgumentException("Value is not a boolean or an integer");
    }

    public Date getDateColumn(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String name = TableRow.canonicalize(column);
        if (this.isColumnNull(name)) {
            return null;
        }
        Object value = this.data.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value is not a Date");
        }
        return (Date)value;
    }

    public void setColumnNull(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        this.setColumnNullInternal(TableRow.canonicalize(column));
    }

    public void setColumn(String column, boolean b) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String canonName = TableRow.canonicalize(column);
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            Integer value;
            Integer n = value = b ? new Integer(1) : new Integer(0);
            if (!value.equals(this.data.get(canonName))) {
                this.data.put(canonName, value);
                this.changed.put(canonName, Boolean.TRUE);
            }
        } else {
            Boolean value;
            Boolean bl = value = b ? Boolean.TRUE : Boolean.FALSE;
            if (!value.equals(this.data.get(canonName))) {
                this.data.put(canonName, value);
                this.changed.put(canonName, Boolean.TRUE);
            }
        }
    }

    public void setColumn(String column, String s) {
        Object value;
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String canonName = TableRow.canonicalize(column);
        Object object = value = s == null ? NULL_OBJECT : s;
        if (!value.equals(this.data.get(canonName))) {
            this.data.put(canonName, value);
            this.changed.put(canonName, Boolean.TRUE);
        }
    }

    public void setColumn(String column, int i) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        Integer value = new Integer(i);
        String canonName = TableRow.canonicalize(column);
        if (!value.equals(this.data.get(canonName))) {
            this.data.put(canonName, value);
            this.changed.put(canonName, Boolean.TRUE);
        }
    }

    public void setColumn(String column, long l) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        Long value = new Long(l);
        String canonName = TableRow.canonicalize(column);
        if (!value.equals(this.data.get(canonName))) {
            this.data.put(canonName, value);
            this.changed.put(canonName, Boolean.TRUE);
        }
    }

    public void setColumn(String column, Date d) {
        Object value;
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("No such column " + column);
        }
        String canonName = TableRow.canonicalize(column);
        Object object = value = d == null ? NULL_OBJECT : d;
        if (!value.equals(this.data.get(canonName))) {
            this.data.put(canonName, value);
            this.changed.put(canonName, Boolean.TRUE);
        }
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer result = this.table == null ? new StringBuffer("no_table") : new StringBuffer(this.table);
        result.append(NEWLINE);
        for (String column : this.data.keySet()) {
            result.append("\t").append(column).append(" = ").append((Object)(this.isColumnNull(column) ? "NULL" : this.data.get(column))).append(NEWLINE);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableRow)) {
            return false;
        }
        return ((Object)this.data).equals(((TableRow)obj).data);
    }

    static String canonicalize(String column) {
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            return column.toUpperCase();
        }
        return column.toLowerCase();
    }

    private void nullColumns(List columns) {
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.setColumnNullInternal((String)iterator.next());
        }
    }

    private void resetChanged(List columns) {
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.changed.put(TableRow.canonicalize((String)iterator.next()), Boolean.FALSE);
        }
    }

    void resetChanged() {
        Iterator iterator = this.changed.keySet().iterator();
        while (iterator.hasNext()) {
            this.changed.put(TableRow.canonicalize((String)iterator.next()), Boolean.FALSE);
        }
    }

    private void setColumnNullInternal(String column) {
        String canonName = TableRow.canonicalize(column);
        if (this.data.get(canonName) != NULL_OBJECT) {
            this.data.put(canonName, NULL_OBJECT);
            this.changed.put(canonName, Boolean.TRUE);
        }
    }
}

