/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class LDAPAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(LDAPAuthentication.class);

    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return ConfigurationManager.getBooleanProperty("webui.ldap.autoregister");
    }

    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    public boolean isImplicit() {
        return false;
    }

    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authenticate(Context context, String netid, String password, String realm, HttpServletRequest request) throws SQLException {
        log.info((Object)LogManager.getHeader(context, "auth", "attempting trivial auth of user=" + netid));
        if (netid == null || password == null) {
            return 5;
        }
        EPerson eperson = null;
        try {
            eperson = EPerson.findByNetid(context, netid.toLowerCase());
        }
        catch (SQLException e) {
            // empty catch block
        }
        boolean loggedIn = false;
        SpeakerToLDAP ldap = new SpeakerToLDAP(log);
        if (eperson != null) {
            if (eperson.getRequireCertificate()) {
                return 3;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (ldap.ldapAuthenticate(netid, password, context)) {
                eperson = EPerson.findByNetid(context, netid.toLowerCase());
                context.setCurrentUser(eperson);
                log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap"));
                return 1;
            }
            return 2;
        }
        if (ldap.ldapAuthenticate(netid, password, context)) {
            log.info((Object)LogManager.getHeader(context, "autoregister", "netid=" + netid));
            if (ldap.ldapEmail != null && !ldap.ldapEmail.equals("")) {
                try {
                    eperson = EPerson.findByEmail(context, ldap.ldapEmail);
                    if (eperson != null) {
                        log.info((Object)LogManager.getHeader(context, "type=ldap-login", "type=ldap_but_already_email"));
                        context.setIgnoreAuthorization(true);
                        eperson.setNetid(netid);
                        eperson.update();
                        context.commit();
                        context.setIgnoreAuthorization(false);
                        context.setCurrentUser(eperson);
                        int n = 1;
                        return n;
                    }
                    if (this.canSelfRegister(context, request, netid)) {
                        try {
                            context.setIgnoreAuthorization(true);
                            eperson = EPerson.create(context);
                            if (ldap.ldapEmail != null && !ldap.ldapEmail.equals("")) {
                                eperson.setEmail(ldap.ldapEmail);
                            } else {
                                eperson.setEmail(netid);
                            }
                            if (ldap.ldapGivenName != null && !ldap.ldapGivenName.equals("")) {
                                eperson.setFirstName(ldap.ldapGivenName);
                            }
                            if (ldap.ldapSurname != null && !ldap.ldapSurname.equals("")) {
                                eperson.setLastName(ldap.ldapSurname);
                            }
                            if (ldap.ldapPhone != null && !ldap.ldapPhone.equals("")) {
                                eperson.setMetadata("phone", ldap.ldapPhone);
                            }
                            eperson.setNetid(netid);
                            eperson.setCanLogIn(true);
                            AuthenticationManager.initEPerson(context, request, eperson);
                            eperson.update();
                            context.commit();
                        }
                        catch (AuthorizeException e) {
                            int n = 4;
                            return n;
                        }
                        finally {
                            context.setIgnoreAuthorization(false);
                        }
                        log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap-login, created ePerson"));
                        int e = 1;
                        return e;
                    }
                    log.info((Object)LogManager.getHeader(context, "failed_login", "type=ldap_but_no_record"));
                    int e = 4;
                    return e;
                }
                catch (AuthorizeException e) {
                    eperson = null;
                }
                finally {
                    context.setIgnoreAuthorization(false);
                }
            }
        }
        return 5;
    }

    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/ldap-login");
    }

    public String loginPageTitle(Context context) {
        return "org.dspace.eperson.LDAPAuthentication.title";
    }

    public class SpeakerToLDAP {
        private Logger log = null;
        protected String ldapEmail = null;
        protected String ldapGivenName = null;
        protected String ldapSurname = null;
        protected String ldapPhone = null;

        SpeakerToLDAP(Logger thelog) {
            this.log = thelog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean ldapAuthenticate(String netid, String password, Context context) {
            block22: {
                if (!password.equals("")) {
                    String ldap_provider_url = ConfigurationManager.getProperty("ldap.provider_url");
                    String ldap_id_field = ConfigurationManager.getProperty("ldap.id_field");
                    String ldap_search_context = ConfigurationManager.getProperty("ldap.search_context");
                    String ldap_object_context = ConfigurationManager.getProperty("ldap.object_context");
                    Hashtable<String, String> env = new Hashtable<String, String>(11);
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.provider.url", ldap_provider_url);
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.security.principal", ldap_id_field + "=" + netid + "," + ldap_object_context);
                    env.put("java.naming.security.credentials", password);
                    InitialDirContext ctx = null;
                    try {
                        ctx = new InitialDirContext(env);
                        String ldap_email_field = ConfigurationManager.getProperty("ldap.email_field");
                        String ldap_givenname_field = ConfigurationManager.getProperty("ldap.givenname_field");
                        String ldap_surname_field = ConfigurationManager.getProperty("ldap.surname_field");
                        String ldap_phone_field = ConfigurationManager.getProperty("ldap.phone_field");
                        BasicAttributes matchAttrs = new BasicAttributes(true);
                        matchAttrs.put(new BasicAttribute(ldap_id_field, netid));
                        String[] attlist = new String[]{ldap_email_field, ldap_givenname_field, ldap_surname_field, ldap_phone_field};
                        try {
                            NamingEnumeration<SearchResult> answer = ctx.search(ldap_search_context, (Attributes)matchAttrs, attlist);
                            while (answer.hasMore()) {
                                Attribute att;
                                SearchResult sr = answer.next();
                                Attributes atts = sr.getAttributes();
                                if (attlist[0] != null && (att = atts.get(attlist[0])) != null) {
                                    this.ldapEmail = (String)att.get();
                                }
                                if (attlist[1] != null && (att = atts.get(attlist[1])) != null) {
                                    this.ldapGivenName = (String)att.get();
                                }
                                if (attlist[2] != null && (att = atts.get(attlist[2])) != null) {
                                    this.ldapSurname = (String)att.get();
                                }
                                if (attlist[3] == null || (att = atts.get(attlist[3])) == null) continue;
                                this.ldapPhone = (String)att.get();
                            }
                            break block22;
                        }
                        catch (NamingException e) {
                            this.log.warn((Object)LogManager.getHeader(context, "ldap_attribute_lookup", "type=failed_search " + e));
                            boolean bl = true;
                            try {
                                if (ctx != null) {
                                    ctx.close();
                                }
                            }
                            catch (NamingException e2) {
                                // empty catch block
                            }
                            return bl;
                        }
                    }
                    catch (NamingException e) {
                        this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "type=failed_auth " + e));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {}
                    }
                }
                return false;
            }
            return true;
        }
    }
}

