/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.event.EventManager;

public class Event
implements Serializable {
    public static final int CREATE = 1;
    public static final int MODIFY = 2;
    public static final int MODIFY_METADATA = 4;
    public static final int ADD = 8;
    public static final int REMOVE = 16;
    public static final int DELETE = 32;
    public static final int SUBJECT_MASK = 0;
    public static final int EVENT_MASK = 1;
    private static final String[] eventTypeText = new String[]{"CREATE", "MODIFY", "MODIFY_METADATA", "ADD", "REMOVE", "DELETE"};
    private static final int NONE = 0;
    private static final int BITSTREAM = 1;
    private static final int BUNDLE = 2;
    private static final int ITEM = 4;
    private static final int COLLECTION = 8;
    private static final int COMMUNITY = 16;
    private static final int SITE = 32;
    private static final int GROUP = 64;
    private static final int EPERSON = 128;
    private static final int ALL_OBJECTS_MASK = 255;
    private static Map<Integer, Integer> objTypeToMask = new HashMap<Integer, Integer>();
    private static Map<Integer, Integer> objMaskToType = new HashMap<Integer, Integer>();
    private int dispatcher;
    private int eventType;
    private int subjectType;
    private int subjectID;
    private int objectType = 0;
    private int objectID = -1;
    private long timeStamp;
    private String detail;
    private String transactionID;
    private int currentUser = -1;
    private String extraLogInfo = null;
    private BitSet consumedBy = new BitSet();
    private static Logger log;

    public Event(int eventType, int subjectType, int subjectID, String detail) {
        this.eventType = eventType;
        this.subjectType = Event.coreTypeToMask(subjectType);
        this.subjectID = subjectID;
        this.timeStamp = System.currentTimeMillis();
        this.detail = detail;
    }

    public Event(int eventType, int subjectType, int subjectID, int objectType, int objectID, String detail) {
        this.eventType = eventType;
        this.subjectType = Event.coreTypeToMask(subjectType);
        this.subjectID = subjectID;
        this.objectType = Event.coreTypeToMask(objectType);
        this.objectID = objectID;
        this.timeStamp = System.currentTimeMillis();
        this.detail = detail;
    }

    public boolean equals(Event other) {
        return (this.detail == null ? other.detail == null : this.detail.equals(other.detail)) && this.eventType == other.eventType && this.subjectType == other.subjectType && this.subjectID == other.subjectID && this.objectType == other.objectType && this.objectID == other.objectID;
    }

    public void setDispatcher(int id) {
        this.dispatcher = id;
    }

    private static int coreTypeToMask(int core) {
        Integer mask = objTypeToMask.get(new Integer(core));
        if (mask == null) {
            return -1;
        }
        return mask;
    }

    private static int maskTypeToCore(int mask) {
        Integer core = objMaskToType.get(new Integer(mask));
        if (core == null) {
            return -1;
        }
        return core;
    }

    public DSpaceObject getObject(Context context) throws SQLException {
        int type = this.getObjectType();
        int id = this.getObjectID();
        if (type < 0 || id < 0) {
            return null;
        }
        return DSpaceObject.find(context, type, id);
    }

    public DSpaceObject getSubject(Context context) throws SQLException {
        return DSpaceObject.find(context, this.getSubjectType(), this.getSubjectID());
    }

    public int getSubjectID() {
        return this.subjectID;
    }

    public int getObjectID() {
        return this.objectID;
    }

    public int getSubjectType() {
        return Event.maskTypeToCore(this.subjectType);
    }

    public int getObjectType() {
        return Event.maskTypeToCore(this.objectType);
    }

    public String getSubjectTypeAsString() {
        int i = Event.log2(this.subjectType);
        if (i >= 0 && i < Constants.typeText.length) {
            return Constants.typeText[i];
        }
        return "(Unknown)";
    }

    public String getObjectTypeAsString() {
        int i = Event.log2(this.objectType);
        if (i >= 0 && i < Constants.typeText.length) {
            return Constants.typeText[i];
        }
        return "(Unknown)";
    }

    public static int parseObjectType(String s) {
        if (s.equals("*") | s.equalsIgnoreCase("all")) {
            return 255;
        }
        int id = Constants.getTypeID(s.toUpperCase());
        if (id >= 0) {
            return 1 << id;
        }
        return 0;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getEventTypeAsString() {
        int i = Event.log2(this.eventType);
        if (i >= 0 && i < eventTypeText.length) {
            return eventTypeText[i];
        }
        return "(Unknown)";
    }

    public static int parseEventType(String s) {
        if (s.equals("*") | s.equalsIgnoreCase("all")) {
            int result = 0;
            for (int i = 0; i < eventTypeText.length; ++i) {
                result |= 1 << i;
            }
            return result;
        }
        for (int i = 0; i < eventTypeText.length; ++i) {
            if (!eventTypeText[i].equalsIgnoreCase(s)) continue;
            return 1 << i;
        }
        return 0;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getDispatcher() {
        return this.dispatcher;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public void setTransactionID(String tid) {
        this.transactionID = tid;
    }

    public void setCurrentUser(int uid) {
        this.currentUser = uid;
    }

    public int getCurrentUser() {
        return this.currentUser;
    }

    public void setExtraLogInfo(String info) {
        this.extraLogInfo = info;
    }

    public String getExtraLogInfo() {
        return this.extraLogInfo;
    }

    public boolean pass(List filters) {
        boolean result = false;
        for (int[] filter : filters) {
            if ((this.subjectType & filter[0]) == 0 || (this.eventType & filter[1]) == 0) continue;
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filtering event: eventType=" + String.valueOf(this.eventType) + ", subjectType=" + String.valueOf(this.subjectType) + ", result=" + String.valueOf(result)));
        }
        return result;
    }

    private static int log2(int n) {
        for (int i = 0; i < 32; ++i) {
            if (n == 1) {
                return i;
            }
            n >>= 1;
        }
        return -1;
    }

    public void setBitSet(String consumerName) {
        this.consumedBy.set(EventManager.getConsumerIndex(consumerName));
    }

    public BitSet getBitSet() {
        return this.consumedBy;
    }

    public String toString() {
        return "org.dspace.event.Event(eventType=" + this.getEventTypeAsString() + ", SubjectType=" + this.getSubjectTypeAsString() + ", SubjectID=" + String.valueOf(this.subjectID) + ", ObjectType=" + this.getObjectTypeAsString() + ", ObjectID=" + String.valueOf(this.objectID) + ", TimeStamp=" + String.valueOf(this.timeStamp) + ", dispatcher=" + String.valueOf(this.dispatcher) + ", detail=" + (this.detail == null ? "[null]" : "\"" + this.detail + "\"") + ", transactionID=" + (this.transactionID == null ? "[null]" : "\"" + this.transactionID + "\"") + ")";
    }

    static {
        objTypeToMask.put(new Integer(0), new Integer(1));
        objMaskToType.put(new Integer(1), new Integer(0));
        objTypeToMask.put(new Integer(1), new Integer(2));
        objMaskToType.put(new Integer(2), new Integer(1));
        objTypeToMask.put(new Integer(2), new Integer(4));
        objMaskToType.put(new Integer(4), new Integer(2));
        objTypeToMask.put(new Integer(3), new Integer(8));
        objMaskToType.put(new Integer(8), new Integer(3));
        objTypeToMask.put(new Integer(4), new Integer(16));
        objMaskToType.put(new Integer(16), new Integer(4));
        objTypeToMask.put(new Integer(5), new Integer(32));
        objMaskToType.put(new Integer(32), new Integer(5));
        objTypeToMask.put(new Integer(6), new Integer(64));
        objMaskToType.put(new Integer(64), new Integer(6));
        objTypeToMask.put(new Integer(7), new Integer(128));
        objMaskToType.put(new Integer(128), new Integer(7));
        log = Logger.getLogger(Event.class);
    }
}

