/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowItem;

public class WorkflowManager {
    public static final int WFSTATE_SUBMIT = 0;
    public static final int WFSTATE_STEP1POOL = 1;
    public static final int WFSTATE_STEP1 = 2;
    public static final int WFSTATE_STEP2POOL = 3;
    public static final int WFSTATE_STEP2 = 4;
    public static final int WFSTATE_STEP3POOL = 5;
    public static final int WFSTATE_STEP3 = 6;
    public static final int WFSTATE_ARCHIVE = 7;
    public static final String[] workflowText = new String[]{"SUBMIT", "STEP1POOL", "STEP1", "STEP2POOL", "STEP2", "STEP3POOL", "STEP3", "ARCHIVE"};
    private static Map noEMail = new HashMap();
    private static Logger log = Logger.getLogger(WorkflowManager.class);

    public static int getWorkflowID(String state) {
        for (int i = 0; i < workflowText.length; ++i) {
            if (!state.equalsIgnoreCase(workflowText[i])) continue;
            return i;
        }
        return -1;
    }

    public static WorkflowItem start(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        Item myitem = wsi.getItem();
        Collection collection = wsi.getCollection();
        log.info((Object)LogManager.getHeader(c, "start_workflow", "workspace_item_id=" + wsi.getID() + "item_id=" + myitem.getID() + "collection_id=" + collection.getID()));
        WorkflowManager.recordStart(c, myitem);
        TableRow row = DatabaseManager.create(c, "workflowitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", wsi.getCollection().getID());
        WorkflowItem wfi = new WorkflowItem(c, row);
        wfi.setMultipleFiles(wsi.hasMultipleFiles());
        wfi.setMultipleTitles(wsi.hasMultipleTitles());
        wfi.setPublishedBefore(wsi.isPublishedBefore());
        wsi.deleteWrapper();
        WorkflowManager.doState(c, wfi, 1, null);
        return wfi;
    }

    public static WorkflowItem startWithoutNotify(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        noEMail.put(new Integer(wsi.getItem().getID()), new Boolean(true));
        return WorkflowManager.start(c, wsi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getOwnedTasks(Context c, EPerson e) throws SQLException {
        ArrayList<WorkflowItem> mylist = new ArrayList<WorkflowItem>();
        String myquery = "SELECT * FROM WorkflowItem WHERE owner= ? ";
        TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", myquery, e.getID());
        try {
            while (tri.hasNext()) {
                mylist.add(new WorkflowItem(c, tri.next()));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return mylist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPooledTasks(Context c, EPerson e) throws SQLException {
        ArrayList<WorkflowItem> mylist = new ArrayList<WorkflowItem>();
        String myquery = "SELECT workflowitem.* FROM workflowitem, TaskListItem WHERE tasklistitem.eperson_id= ?  AND tasklistitem.workflow_id=workflowitem.workflow_id";
        TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", myquery, e.getID());
        try {
            while (tri.hasNext()) {
                mylist.add(new WorkflowItem(c, tri.next()));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return mylist;
    }

    public static void claim(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        switch (taskstate) {
            case 1: {
                WorkflowManager.doState(c, wi, 2, e);
                break;
            }
            case 3: {
                WorkflowManager.doState(c, wi, 4, e);
                break;
            }
            case 5: {
                WorkflowManager.doState(c, wi, 6, e);
            }
        }
        log.info((Object)LogManager.getHeader(c, "claim_task", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "newowner_id=" + wi.getOwner().getID() + "old_state=" + taskstate + "new_state=" + wi.getState()));
    }

    public static void advance(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        switch (taskstate) {
            case 2: {
                WorkflowManager.recordApproval(c, wi, e);
                WorkflowManager.doState(c, wi, 3, e);
                break;
            }
            case 4: {
                WorkflowManager.recordApproval(c, wi, e);
                WorkflowManager.doState(c, wi, 5, e);
                break;
            }
            case 6: {
                WorkflowManager.doState(c, wi, 7, e);
            }
        }
        log.info((Object)LogManager.getHeader(c, "advance_workflow", "workflow_item_id=" + wi.getID() + ",item_id=" + wi.getItem().getID() + ",collection_id=" + wi.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + wi.getState()));
    }

    public static void unclaim(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        switch (taskstate) {
            case 2: {
                WorkflowManager.doState(c, wi, 1, e);
                break;
            }
            case 4: {
                WorkflowManager.doState(c, wi, 3, e);
                break;
            }
            case 6: {
                WorkflowManager.doState(c, wi, 5, e);
            }
        }
        log.info((Object)LogManager.getHeader(c, "unclaim_workflow", "workflow_item_id=" + wi.getID() + ",item_id=" + wi.getItem().getID() + ",collection_id=" + wi.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + wi.getState()));
    }

    public static void abort(Context c, WorkflowItem wi, EPerson e) throws SQLException, AuthorizeException, IOException {
        if (!AuthorizeManager.isAdmin(c)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        WorkflowManager.deleteTasks(c, wi);
        log.info((Object)LogManager.getHeader(c, "abort_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        WorkspaceItem wsi = WorkflowManager.returnToWorkspace(c, wi);
    }

    private static boolean doState(Context c, WorkflowItem wi, int newstate, EPerson newowner) throws SQLException, IOException, AuthorizeException {
        Collection mycollection = wi.getCollection();
        Group mygroup = null;
        boolean archived = false;
        wi.setState(newstate);
        switch (newstate) {
            case 1: {
                wi.setOwner(null);
                mygroup = mycollection.getWorkflowGroup(1);
                if (mygroup != null && !mygroup.isEmpty()) {
                    EPerson[] epa = Group.allMembers(c, mygroup);
                    WorkflowManager.createTasks(c, wi, epa);
                    wi.update();
                    WorkflowManager.notifyGroupOfTask(c, wi, mygroup, epa);
                    break;
                }
                archived = WorkflowManager.doState(c, wi, 3, null);
                break;
            }
            case 2: {
                WorkflowManager.deleteTasks(c, wi);
                wi.setOwner(newowner);
                break;
            }
            case 3: {
                wi.setOwner(null);
                mygroup = mycollection.getWorkflowGroup(2);
                if (mygroup != null && !mygroup.isEmpty()) {
                    EPerson[] epa = Group.allMembers(c, mygroup);
                    WorkflowManager.createTasks(c, wi, epa);
                    WorkflowManager.notifyGroupOfTask(c, wi, mygroup, epa);
                    break;
                }
                archived = WorkflowManager.doState(c, wi, 5, null);
                break;
            }
            case 4: {
                WorkflowManager.deleteTasks(c, wi);
                wi.setOwner(newowner);
                break;
            }
            case 5: {
                wi.setOwner(null);
                mygroup = mycollection.getWorkflowGroup(3);
                if (mygroup != null && !mygroup.isEmpty()) {
                    EPerson[] epa = Group.allMembers(c, mygroup);
                    WorkflowManager.createTasks(c, wi, epa);
                    WorkflowManager.notifyGroupOfTask(c, wi, mygroup, epa);
                    break;
                }
                archived = WorkflowManager.doState(c, wi, 7, newowner);
                break;
            }
            case 6: {
                WorkflowManager.deleteTasks(c, wi);
                wi.setOwner(newowner);
                break;
            }
            case 7: {
                try {
                    WorkflowManager.deleteTasks(c, wi);
                    mycollection = wi.getCollection();
                    Item myitem = WorkflowManager.archive(c, wi);
                    WorkflowManager.notifyOfArchive(c, myitem, mycollection);
                    archived = true;
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw e;
                }
            }
        }
        if (wi != null && !archived) {
            wi.update();
        }
        return archived;
    }

    private static Item archive(Context c, WorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item item = wfi.getItem();
        Collection collection = wfi.getCollection();
        log.info((Object)LogManager.getHeader(c, "archive_item", "workflow_item_id=" + wfi.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        InstallItem.installItem(c, wfi);
        log.info((Object)LogManager.getHeader(c, "install_item", "workflow_id=" + wfi.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    private static void notifyOfArchive(Context c, Item i, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = i.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = HandleManager.findHandle(c, i);
            DCValue[] titles = i.getDC("title", null, "*");
            String title = "";
            try {
                title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                title = "Untitled";
            }
            if (titles.length > 0) {
                title = titles[0].value;
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(HandleManager.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            log.warn((Object)LogManager.getHeader(c, "notifyOfArchive", "cannot email user item_id=" + i.getID()));
        }
    }

    private static WorkspaceItem returnToWorkspace(Context c, WorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item myitem = wfi.getItem();
        Collection mycollection = wfi.getCollection();
        TableRow row = DatabaseManager.create(c, "workspaceitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", mycollection.getID());
        DatabaseManager.update(c, row);
        int wsi_id = row.getIntColumn("workspace_item_id");
        WorkspaceItem wi = WorkspaceItem.find(c, wsi_id);
        wi.setMultipleFiles(wfi.hasMultipleFiles());
        wi.setMultipleTitles(wfi.hasMultipleTitles());
        wi.setPublishedBefore(wfi.isPublishedBefore());
        wi.update();
        log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + wi.getID()));
        DatabaseManager.updateQuery(c, "DELETE FROM WorkflowItem WHERE workflow_id=" + wfi.getID(), new Object[0]);
        return wi;
    }

    public static WorkspaceItem reject(Context c, WorkflowItem wi, EPerson e, String rejection_message) throws SQLException, AuthorizeException, IOException {
        WorkflowManager.deleteTasks(c, wi);
        Item myitem = wi.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = WorkflowManager.getEPersonName(e);
        String provDescription = "Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        myitem.addDC("description", "provenance", "en", provDescription);
        myitem.update();
        WorkspaceItem wsi = WorkflowManager.returnToWorkspace(c, wi);
        WorkflowManager.notifyOfReject(c, wi, e, rejection_message);
        log.info((Object)LogManager.getHeader(c, "reject_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        return wsi;
    }

    private static void createTasks(Context c, WorkflowItem wi, EPerson[] epa) throws SQLException {
        for (int i = 0; i < epa.length; ++i) {
            TableRow tr = DatabaseManager.create(c, "tasklistitem");
            tr.setColumn("eperson_id", epa[i].getID());
            tr.setColumn("workflow_id", wi.getID());
            DatabaseManager.update(c, tr);
        }
    }

    static void deleteTasks(Context c, WorkflowItem wi) throws SQLException {
        String myrequest = "DELETE FROM TaskListItem WHERE workflow_id= ? ";
        DatabaseManager.updateQuery(c, myrequest, wi.getID());
    }

    private static void notifyGroupOfTask(Context c, WorkflowItem wi, Group mygroup, EPerson[] epa) throws SQLException, IOException {
        Integer myID = new Integer(wi.getItem().getID());
        if (noEMail.containsKey(myID)) {
            noEMail.remove(myID);
        } else {
            try {
                String title = WorkflowManager.getItemTitle(wi);
                String submitter = WorkflowManager.getSubmitterName(wi);
                Collection coll = wi.getCollection();
                String message = "";
                for (int i = 0; i < epa.length; ++i) {
                    Locale supportedLocale = I18nUtil.getEPersonLocale(epa[i]);
                    Email email = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_task"));
                    email.addArgument(title);
                    email.addArgument(coll.getMetadata("name"));
                    email.addArgument(submitter);
                    ResourceBundle messages = ResourceBundle.getBundle("Messages", supportedLocale);
                    log.info((Object)("Locale des Resource Bundles: " + messages.getLocale().getDisplayName()));
                    switch (wi.getState()) {
                        case 1: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step1");
                            break;
                        }
                        case 3: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step2");
                            break;
                        }
                        case 5: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step3");
                        }
                    }
                    email.addArgument(message);
                    email.addArgument(WorkflowManager.getMyDSpaceLink());
                    email.addRecipient(epa[i].getEmail());
                    email.send();
                }
            }
            catch (MessagingException e) {
                log.warn((Object)LogManager.getHeader(c, "notifyGroupofTask", "cannot email user group_id" + mygroup.getID() + " workflow_item_id" + wi.getID()));
            }
        }
    }

    private static void emailRecipients(Context c, EPerson[] epa, Email email) throws SQLException, MessagingException {
        for (int i = 0; i < epa.length; ++i) {
            email.addRecipient(epa[i].getEmail());
        }
        email.send();
    }

    private static String getMyDSpaceLink() {
        return ConfigurationManager.getProperty("dspace.url") + "/mydspace";
    }

    private static void notifyOfReject(Context c, WorkflowItem wi, EPerson e, String reason) {
        try {
            String title = WorkflowManager.getItemTitle(wi);
            Collection coll = wi.getCollection();
            String rejector = WorkflowManager.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(WorkflowManager.getSubmitterEPerson(wi).getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(WorkflowManager.getMyDSpaceLink());
            email.send();
        }
        catch (Exception ex) {
            log.warn((Object)LogManager.getHeader(c, "notify_of_reject", "cannot email user eperson_id" + e.getID() + " eperson_email" + e.getEmail() + " workflow_item_id" + wi.getID()));
        }
    }

    private static EPerson getSubmitterEPerson(WorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return e;
    }

    public static String getItemTitle(WorkflowItem wi) throws SQLException {
        Item myitem = wi.getItem();
        DCValue[] titles = myitem.getDC("title", null, "*");
        if (titles.length > 0) {
            return titles[0].value;
        }
        return I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled ");
    }

    public static String getSubmitterName(WorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return WorkflowManager.getEPersonName(e);
    }

    private static String getEPersonName(EPerson e) throws SQLException {
        String submitter = e.getFullName();
        submitter = submitter + "(" + e.getEmail() + ")";
        return submitter;
    }

    private static void recordApproval(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        Item item = wi.getItem();
        String usersName = WorkflowManager.getEPersonName(e);
        String now = DCDate.getCurrent().toString();
        String provDescription = "Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        provDescription = provDescription + InstallItem.getBitstreamProvenanceMessage(item);
        item.addDC("description", "provenance", "en", provDescription);
        item.update();
    }

    private static void recordStart(Context c, Item myitem) throws SQLException, IOException, AuthorizeException {
        Bitstream[] bitstreams = myitem.getNonInternalBitstreams();
        DCDate now = DCDate.getCurrent();
        String provmessage = "";
        provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + "\n";
        provmessage = provmessage + InstallItem.getBitstreamProvenanceMessage(myitem);
        myitem.addDC("description", "provenance", "en", provmessage);
        myitem.update();
    }
}

