/*
 * PackageValidationException.java
 *
 * Version: $Revision: 1417 $
 *
 * Date: $Date: 2006-02-13 02:33:50 -0800 (Mon, 13 Feb 2006) $
 *
 * Copyright (c) 2002-2005, Hewlett-Packard Company and Massachusetts
 * Institute of Technology.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the Hewlett-Packard Company nor the name of the
 * Massachusetts Institute of Technology nor the names of their
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

package org.dspace.content.packager;

/**
 * This represents a failure when importing or exporting a package
 * caused by invalid unacceptable package format or contents; for
 * example, missing files that were mentioned in the manifest, or
 * extra files not in manifest, or lack of a manifest.
 * <p>
 * When throwing a PackageValidationException, be sure the message
 * includes enough specific information to let the end user diagnose
 * the problem, i.e. what files appear to be missing from the manifest
 * or package, or the details of a checksum error on a file.
 *
 * @author Larry Stone
 * @version $Revision: 1417 $
 */
public class PackageValidationException extends PackageException
{
    /**
     * Create a new exception with the given message.
     * @param s - diagnostic message.
     */
    public PackageValidationException(String message)
    {
        super(message);
    }

    /**
     * Create a new exception wrapping it around another exception.
     * @param e - exception specifying the cause of this failure.
     */
    public PackageValidationException(Exception exception)
    {
        super(exception);
    }
}
