/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import org.dspace.content.DCDate;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Upgrade101To11 {
    public static void main(String[] argv) {
        Context context = null;
        try {
            DCDate d;
            context = new Context();
            TableRowIterator tri = DatabaseManager.queryTable(context, "item", "SELECT * FROM item WHERE withdrawal_date IS NOT NULL", new Object[0]);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                d = new DCDate(row.getStringColumn("withdrawal_date"));
                row.setColumn("last_modified", d.toDate());
                DatabaseManager.update(context, row);
            }
            tri.close();
            tri = DatabaseManager.query(context, "SELECT item.item_id, dcvalue.text_value FROM item, dctyperegistry, dcvalue WHERE item.item_id=dcvalue.item_id AND dcvalue.dc_type_id=dctyperegistry.dc_type_id AND dctyperegistry.element LIKE 'date' AND dctyperegistry.qualifier LIKE 'available'", new Object[0]);
            while (tri.hasNext()) {
                TableRow resultRow = tri.next();
                d = new DCDate(resultRow.getStringColumn("text_value"));
                TableRow itemRow = DatabaseManager.find(context, "item", resultRow.getIntColumn("item_id"));
                itemRow.setColumn("last_modified", d.toDate());
                DatabaseManager.update(context, itemRow);
            }
            tri.close();
            DatabaseManager.updateQuery(context, "UPDATE item SET last_modified=now() WHERE last_modified IS NULL", new Object[0]);
            context.complete();
            System.out.println("Last modified dates set");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Exception occurred:" + e);
            e.printStackTrace();
            if (context != null) {
                context.abort();
            }
            System.exit(1);
        }
    }
}

